/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl;

import com.sap.cds.services.Service;
import com.sap.cds.services.ServiceCatalog;
import com.sap.cds.services.cds.ApplicationService;
import com.sap.cds.services.cds.RemoteService;
import com.sap.cds.services.environment.CdsProperties;
import com.sap.cds.services.handler.Handler;
import com.sap.cds.services.handler.annotations.After;
import com.sap.cds.services.handler.annotations.Before;
import com.sap.cds.services.handler.annotations.On;
import com.sap.cds.services.impl.EventPredicate;
import com.sap.cds.services.impl.Phase;
import com.sap.cds.services.impl.ServiceSPI;
import com.sap.cds.services.impl.utils.CdsServiceUtils;
import com.sap.cds.services.messaging.MessagingService;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.runtime.CdsRuntimeAware;
import com.sap.cds.services.utils.info.CdsInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.stream.Stream;

public class ServiceCatalogInfo
implements CdsInfo,
CdsRuntimeAware {
    private CdsRuntime runtime;

    public String name() {
        return "services";
    }

    public void setCdsRuntime(CdsRuntime runtime) {
        this.runtime = runtime;
    }

    public Map<String, Object> info(CdsInfo.Details flavor) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (this.runtime != null) {
            ServiceCatalog catalog = this.runtime.getServiceCatalog();
            catalog.getServices().forEach(service -> {
                HashMap serviceMap = new HashMap();
                Stream.of(Info.values()).filter(i -> flavor.compareTo((Enum)i.minFlavor) >= 0).forEach(info -> {
                    Object value = info.valueFunc.apply((Service)service, this.runtime);
                    if (value != null) {
                        serviceMap.put(info.name, value);
                    }
                });
                result.put(service.getName(), serviceMap);
            });
        }
        return result;
    }

    private static String type(Service service, CdsRuntime runtime) {
        return CdsServiceUtils.getServiceType(service).getName();
    }

    private static Object properties(Service service, CdsRuntime runtime) {
        CdsProperties properties = runtime.getEnvironment().getCdsProperties();
        if (service instanceof ApplicationService) {
            return properties.getApplication().getServices().values().stream().filter(srv -> service.getName().equals(srv.getName())).findAny().orElse(null);
        }
        if (service instanceof RemoteService) {
            return properties.getRemote().getServices().values().stream().filter(srv -> service.getName().equals(srv.getName())).findAny().orElse(null);
        }
        if (service instanceof MessagingService) {
            return properties.getMessaging().getServices().values().stream().filter(srv -> service.getName().equals(srv.getName())).findAny().orElse(null);
        }
        return null;
    }

    private static Map<String, Object> handlers(Service service, CdsRuntime runtime) {
        ServiceSPI serviceSPI = CdsServiceUtils.getServiceSPI(service);
        if (serviceSPI != null) {
            List<HandlerDescription> afterHandlers;
            List<HandlerDescription> onHandlers;
            LinkedHashMap<String, Object> handlers = new LinkedHashMap<String, Object>();
            List<HandlerDescription> beforeHandlers = ServiceCatalogInfo.createHandlerDescriptions(serviceSPI, Phase.BEFORE);
            if (!beforeHandlers.isEmpty()) {
                handlers.put(Before.class.getSimpleName(), beforeHandlers);
            }
            if (!(onHandlers = ServiceCatalogInfo.createHandlerDescriptions(serviceSPI, Phase.ON)).isEmpty()) {
                handlers.put(On.class.getSimpleName(), onHandlers);
            }
            if (!(afterHandlers = ServiceCatalogInfo.createHandlerDescriptions(serviceSPI, Phase.AFTER)).isEmpty()) {
                handlers.put(After.class.getSimpleName(), afterHandlers);
            }
            return handlers;
        }
        return null;
    }

    private static List<HandlerDescription> createHandlerDescriptions(ServiceSPI serviceSPI, Phase phase) {
        ArrayList<HandlerDescription> handlers = new ArrayList<HandlerDescription>();
        serviceSPI.registrations(phase).forEach(r -> {
            HandlerDescription description = new HandlerDescription();
            Handler handler = r.getHandler();
            description.handler = handler.toString();
            EventPredicate predicate = r.getEventPredicate();
            description.predicate = predicate == EventPredicate.ALL ? "event '*' on entity '*'" : r.getEventPredicate().toString();
            handlers.add(description);
        });
        return handlers;
    }

    static class HandlerDescription {
        public String handler;
        public String predicate;

        HandlerDescription() {
        }
    }

    public static enum Info {
        TYPE("type", ServiceCatalogInfo::type, CdsInfo.Details.LOW),
        PROPERTIES("properties", ServiceCatalogInfo::properties, CdsInfo.Details.MEDIUM),
        HANDLERS("handlers", ServiceCatalogInfo::handlers, CdsInfo.Details.HIGH);

        String name;
        BiFunction<Service, CdsRuntime, ?> valueFunc;
        CdsInfo.Details minFlavor;

        private Info(String name, BiFunction<Service, CdsRuntime, ?> valueFunc, CdsInfo.Details minFlavor) {
            this.name = name;
            this.valueFunc = valueFunc;
            this.minFlavor = minFlavor;
        }

        public String getName() {
            return this.name;
        }
    }
}

