/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.auditlog;

import com.sap.cds.CdsData;
import com.sap.cds.Struct;
import com.sap.cds.impl.parser.StructDataParser;
import com.sap.cds.reflect.CdsEvent;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.reflect.impl.CdsModelReader;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.EventContext;
import com.sap.cds.services.Service;
import com.sap.cds.services.auditlog.Action;
import com.sap.cds.services.auditlog.ConfigChangeLog;
import com.sap.cds.services.auditlog.ConfigChangeLogContext;
import com.sap.cds.services.auditlog.DataAccessLog;
import com.sap.cds.services.auditlog.DataAccessLogContext;
import com.sap.cds.services.auditlog.DataModificationLog;
import com.sap.cds.services.auditlog.DataModificationLogContext;
import com.sap.cds.services.auditlog.SecurityLog;
import com.sap.cds.services.auditlog.SecurityLogContext;
import com.sap.cds.services.handler.EventHandler;
import com.sap.cds.services.handler.annotations.Before;
import com.sap.cds.services.handler.annotations.On;
import com.sap.cds.services.handler.annotations.ServiceName;
import com.sap.cds.services.impl.auditlog.events.TenantOffboardedEvent;
import com.sap.cds.services.impl.auditlog.events.TenantOnboardedEvent;
import com.sap.cds.services.impl.auditlog.events.security.UnauthorizedRequestEvent;
import com.sap.cds.services.outbox.OutboxMessage;
import com.sap.cds.services.outbox.OutboxMessageEventContext;
import com.sap.cds.services.outbox.OutboxService;
import com.sap.cds.services.outbox.StoredRequestContext;
import com.sap.cds.services.request.RequestContext;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.runtime.RequestContextRunner;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import com.sap.cds.services.utils.StringUtils;
import com.sap.cds.services.utils.outbox.OutboxUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Map;

@ServiceName(value={"*"}, type={OutboxService.class})
public class AuditLogOutboxHandler
implements EventHandler {
    private static final String USER = "user";
    private static final String TENANT = "tenant";
    private static final String LOGON_NAME = "logonName";
    private static final String IS_AUTHENTICATED = "isAuthenticated";
    private static final String IS_SYSTEM_USER = "isSystemUser";
    private static final String DATA = "data";
    private static final String CREATED_AT = "createdAt";
    private static final String ACTION = "action";
    private static final String MODIFICATIONS = "modifications";
    private CdsModel auditlogModel;

    public AuditLogOutboxHandler() {
        String csnPath = "com/sap/cds/auditlog.csn";
        try (InputStream is = AuditLogOutboxHandler.class.getClassLoader().getResourceAsStream(csnPath);){
            if (is == null) {
                throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.NO_AUDITLOG_MODEL, new Object[]{csnPath});
            }
            this.auditlogModel = CdsModelReader.read((InputStream)is);
        }
        catch (IOException e) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.AUDITLOG_NOT_READABLE, new Object[]{csnPath, e});
        }
    }

    @On(event={"AuditlogService$Default"})
    private void publishedByOutbox(OutboxMessageEventContext context) {
        Service auditlogService = OutboxService.unboxed((Service)context.getServiceCatalog().getService("AuditlogService$Default"));
        RequestContextRunner runner = context.getCdsRuntime().requestContext();
        OutboxUtils.restoreRequestContext((RequestContextRunner)runner, (OutboxMessage)context.getMessage());
        runner.modifyUser(u -> {
            RequestContextAccessor requestContextAccessor;
            StoredRequestContext storedRequestContext = context.getMessage().getStoredRequestContext();
            if (storedRequestContext != null) {
                requestContextAccessor = new RequestContextAccessor((Map<String, Object>)storedRequestContext, context.getEvent());
            } else {
                requestContextAccessor = new RequestContextAccessor((Map<String, Object>)context.getMessage(), context.getEvent());
                u.setTenant(requestContextAccessor.tenant);
            }
            u.setName(requestContextAccessor.user);
            u.setIsAuthenticated(requestContextAccessor.isAuthenticated);
            u.setIsSystemUser(requestContextAccessor.isSystemUser);
            u.setAdditionalAttribute(LOGON_NAME, (Object)requestContextAccessor.logonName);
        }).run(req -> {
            EventContextAccessor contextAccessor = new EventContextAccessor(context, this.auditlogModel);
            auditlogService.emit(contextAccessor.context);
        });
        context.setCompleted();
    }

    @Before(event={"AuditlogService$Default"})
    private void prepareOutboxMessage(OutboxMessageEventContext context) {
        if (Boolean.TRUE.equals(context.getIsInbound())) {
            return;
        }
        OutboxMessage message = context.getMessage();
        try {
            RequestContext requestContext = RequestContext.getCurrent((CdsRuntime)context.getCdsRuntime());
            StoredRequestContext storedRequestContext = context.getMessage().getStoredRequestContext();
            if (storedRequestContext == null) {
                storedRequestContext = StoredRequestContext.create();
                message.setStoredRequestContext(storedRequestContext);
            }
            storedRequestContext.put((Object)USER, (Object)requestContext.getUserInfo().getName());
            storedRequestContext.put((Object)IS_AUTHENTICATED, (Object)requestContext.getUserInfo().isAuthenticated());
            storedRequestContext.put((Object)IS_SYSTEM_USER, (Object)requestContext.getUserInfo().isSystemUser());
            String logonName = (String)requestContext.getUserInfo().getAdditionalAttribute(LOGON_NAME);
            if (!StringUtils.isEmpty((String)logonName)) {
                storedRequestContext.put((Object)LOGON_NAME, (Object)logonName);
            }
            CdsData data = (CdsData)message.getParams().get(DATA);
            message.getParams().clear();
            message.getParams().put(DATA, data.toJson());
        }
        catch (Exception e) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.CONTEXT_SERIALIZATION_FAILED, new Object[]{context.getEvent(), e});
        }
    }

    private static class EventContextAccessor {
        private final EventContext context;

        private EventContextAccessor(OutboxMessageEventContext outboxContext, CdsModel auditlogModel) {
            try {
                this.context = OutboxUtils.toEventContext((OutboxMessageEventContext)outboxContext);
                OutboxMessage message = outboxContext.getMessage();
                CdsEvent type = auditlogModel.getEvent("com.sap.cds.services.auditlog." + this.context.getEvent());
                String dataJson = message.getParams() == null ? (String)message.get((Object)AuditLogOutboxHandler.DATA) : (String)this.context.get(AuditLogOutboxHandler.DATA);
                Map data = StructDataParser.create((CdsStructuredType)type).parseObject(dataJson);
                this.adaptActionType(data, this.context.getEvent());
                this.setData(this.context, this.context.getEvent(), data);
                this.context.put(AuditLogOutboxHandler.CREATED_AT, (Object)outboxContext.getTimestamp());
            }
            catch (Exception e) {
                throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.CONTEXT_DESERIALIZATION_FAILED, new Object[]{outboxContext.getEvent(), e});
            }
        }

        private void setData(EventContext context, String event, Map<String, Object> data) {
            if (event.equals("dataModificationLog")) {
                DataModificationLog log = (DataModificationLog)Struct.access(data).as(DataModificationLog.class);
                ((DataModificationLogContext)context.as(DataModificationLogContext.class)).setData(log);
            } else if (event.equals("configChangeLog")) {
                ConfigChangeLog log = (ConfigChangeLog)Struct.access(data).as(ConfigChangeLog.class);
                ((ConfigChangeLogContext)context.as(ConfigChangeLogContext.class)).setData(log);
            } else if (event.equals("securityLog")) {
                SecurityLog log = (SecurityLog)Struct.access(data).as(SecurityLog.class);
                ((SecurityLogContext)context.as(SecurityLogContext.class)).setData(log);
            } else if (event.equals("dataAccessLog")) {
                DataAccessLog log = (DataAccessLog)Struct.access(data).as(DataAccessLog.class);
                ((DataAccessLogContext)context.as(DataAccessLogContext.class)).setData(log);
            } else if (event.equals("tenantOnboarded")) {
                TenantOnboardedEvent log = (TenantOnboardedEvent)Struct.access(data).as(TenantOnboardedEvent.class);
                context.put(AuditLogOutboxHandler.DATA, (Object)log);
            } else if (event.equals("tenantOffboarded")) {
                TenantOffboardedEvent log = (TenantOffboardedEvent)Struct.access(data).as(TenantOffboardedEvent.class);
                context.put(AuditLogOutboxHandler.DATA, (Object)log);
            } else if (event.equals("unauthorizedRequest")) {
                UnauthorizedRequestEvent log = (UnauthorizedRequestEvent)Struct.access(data).as(UnauthorizedRequestEvent.class);
                context.put(AuditLogOutboxHandler.DATA, (Object)log);
            }
        }

        private void adaptActionType(Map<String, Object> data, String event) {
            Object action;
            if (event.equals("dataModificationLog")) {
                Collection modifications = (Collection)data.get(AuditLogOutboxHandler.MODIFICATIONS);
                if (modifications != null) {
                    modifications.forEach(modification -> {
                        Object action = modification.get(AuditLogOutboxHandler.ACTION);
                        if (action != null) {
                            modification.put(AuditLogOutboxHandler.ACTION, Action.valueOf((String)action.toString()));
                        }
                    });
                }
            } else if (event.equals("configChangeLog") && (action = data.get(AuditLogOutboxHandler.ACTION)) != null) {
                data.put(AuditLogOutboxHandler.ACTION, Action.valueOf((String)action.toString()));
            }
        }
    }

    private static class RequestContextAccessor {
        private final String user;
        private final String tenant;
        private final String logonName;
        private final boolean isAuthenticated;
        private final boolean isSystemUser;

        public RequestContextAccessor(Map<String, Object> map, String outboxEvent) {
            try {
                this.user = (String)map.get(AuditLogOutboxHandler.USER);
                this.tenant = (String)map.get(AuditLogOutboxHandler.TENANT);
                this.logonName = (String)map.get(AuditLogOutboxHandler.LOGON_NAME);
                this.isAuthenticated = Boolean.TRUE.equals(map.get(AuditLogOutboxHandler.IS_AUTHENTICATED));
                this.isSystemUser = Boolean.TRUE.equals(map.get(AuditLogOutboxHandler.IS_SYSTEM_USER));
            }
            catch (Exception e) {
                throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.CONTEXT_DESERIALIZATION_FAILED, new Object[]{outboxEvent, e});
            }
        }
    }
}

