/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.auditlog;

import com.sap.cds.services.EventContext;
import com.sap.cds.services.Service;
import com.sap.cds.services.ServiceDelegator;
import com.sap.cds.services.auditlog.Access;
import com.sap.cds.services.auditlog.Action;
import com.sap.cds.services.auditlog.AuditLogService;
import com.sap.cds.services.auditlog.ConfigChange;
import com.sap.cds.services.auditlog.ConfigChangeLog;
import com.sap.cds.services.auditlog.ConfigChangeLogContext;
import com.sap.cds.services.auditlog.DataAccessLog;
import com.sap.cds.services.auditlog.DataAccessLogContext;
import com.sap.cds.services.auditlog.DataModification;
import com.sap.cds.services.auditlog.DataModificationLog;
import com.sap.cds.services.auditlog.DataModificationLogContext;
import com.sap.cds.services.auditlog.SecurityLog;
import com.sap.cds.services.auditlog.SecurityLogContext;
import com.sap.cds.services.environment.CdsProperties;
import com.sap.cds.services.handler.annotations.HandlerOrder;
import com.sap.cds.services.handler.annotations.On;
import com.sap.cds.services.impl.auditlog.events.TenantOffboardedEvent;
import com.sap.cds.services.impl.auditlog.events.TenantOnboardedEvent;
import com.sap.cds.services.impl.auditlog.events.security.UnauthorizedRequestEvent;
import com.sap.cds.services.impl.utils.CdsServiceUtils;
import com.sap.cds.services.runtime.CdsRuntime;
import java.time.Instant;
import java.util.List;

public class AuditLogServiceImpl
extends ServiceDelegator
implements AuditLogService {
    private final CdsRuntime runtime;

    AuditLogServiceImpl(String name, CdsRuntime runtime) {
        super(name);
        this.runtime = runtime;
    }

    public void logDataAccess(List<Access> accesses) {
        DataAccessLog log = DataAccessLog.create();
        log.setAccesses(accesses);
        DataAccessLogContext context = DataAccessLogContext.create();
        context.setData(log);
        this.emit((EventContext)context);
    }

    public void logDataModification(List<DataModification> modifications) {
        DataModificationLog log = DataModificationLog.create();
        log.setModifications(modifications);
        DataModificationLogContext context = DataModificationLogContext.create();
        context.setData(log);
        this.emit((EventContext)context);
    }

    public void logConfigChange(Action action, List<ConfigChange> configurations) {
        ConfigChangeLog changeLog = ConfigChangeLog.create();
        changeLog.setAction(action);
        changeLog.setConfigurations(configurations);
        ConfigChangeLogContext context = ConfigChangeLogContext.create();
        context.setData(changeLog);
        this.emit((EventContext)context);
    }

    public void logSecurityEvent(String action, String data) {
        SecurityLog log = SecurityLog.create();
        log.setAction(action);
        log.setData(data);
        SecurityLogContext context = SecurityLogContext.create();
        context.setData(log);
        this.emit((EventContext)context);
    }

    public void emit(EventContext context) {
        this.prepareStandardAuditlogEvents(context);
        if (context.getEvent().equals("securityLog")) {
            CdsServiceUtils.getServiceSPI((Service)this).setOutbox(null);
        }
        super.emit(context);
    }

    private void prepareStandardAuditlogEvents(EventContext context) {
        CdsProperties.AuditLog.StandardEvents standardEvents = this.runtime.getEnvironment().getCdsProperties().getAuditLog().getStandardEvents();
        if (standardEvents.isEnabled().booleanValue() && context.get("data") == null) {
            if (Boolean.TRUE.equals(standardEvents.getTenantLifecycleEvents().isEnabled()) && "tenantOnboarded".equals(context.getEvent())) {
                String tenant = (String)context.get("tenant");
                TenantOnboardedEvent tenantOnboarded = TenantOnboardedEvent.create(tenant, this.runtime);
                context.put("createdAt", (Object)Instant.now());
                context.put("data", (Object)tenantOnboarded);
            } else if (Boolean.TRUE.equals(standardEvents.getTenantLifecycleEvents().isEnabled()) && "tenantOffboarded".equals(context.getEvent())) {
                String tenant = (String)context.get("tenant");
                TenantOffboardedEvent tenantOffboarded = TenantOffboardedEvent.create(tenant, this.runtime);
                context.put("createdAt", (Object)Instant.now());
                context.put("data", (Object)tenantOffboarded);
            } else if (Boolean.TRUE.equals(standardEvents.getUnauthorizedRequestEvent().isEnabled()) && "unauthorizedRequest".equals(context.getEvent())) {
                String rejectReason = (String)context.get("rejectReason");
                UnauthorizedRequestEvent unauthorized = UnauthorizedRequestEvent.create(rejectReason, this.runtime);
                context.put("createdAt", (Object)Instant.now());
                context.put("data", (Object)unauthorized);
            }
        }
    }

    @On
    @HandlerOrder(value=0x7FFFFFFE)
    private void autoComplete(EventContext context) {
        context.setCompleted();
    }
}

