/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.auditlog;

import com.sap.cds.reflect.CdsAssociationType;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.reflect.CdsElementDefinition;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.ServiceException;
import com.sap.cds.services.auditlog.DataObject;
import com.sap.cds.services.auditlog.DataSubject;
import com.sap.cds.services.auditlog.KeyValuePair;
import com.sap.cds.services.environment.CdsProperties;
import com.sap.cds.services.impl.auditlog.PersonalDataCaches;
import com.sap.cds.services.impl.auditlog.PersonalDataMeta;
import com.sap.cds.services.impl.auditlog.PersonalDataUtils;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.utils.CdsErrorStatuses;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class PersonalDataAnalyzer {
    private static final Logger logger = LoggerFactory.getLogger(PersonalDataAnalyzer.class);
    protected final CdsStructuredType entity;
    protected final PersonalDataCaches caches;
    protected final boolean throwOnMissingDataSubject;
    protected List<? extends Map<String, Object>> data;
    protected final CdsProperties.AuditLog.PersonalData personalData;

    protected PersonalDataAnalyzer(CdsStructuredType entity, PersonalDataCaches caches, CdsRuntime runtime) {
        this.entity = Objects.requireNonNull(entity, "entity must not be null");
        this.caches = Objects.requireNonNull(caches, "caches must not be null");
        this.throwOnMissingDataSubject = runtime.getEnvironment().getCdsProperties().getAuditLog().getPersonalData().isThrowOnMissingDataSubject();
        this.personalData = runtime.getEnvironment().getCdsProperties().getAuditLog().getPersonalData();
    }

    abstract boolean hasPersonalData();

    public final void setData(List<? extends Map<String, Object>> data) {
        this.data = data;
    }

    protected DataObject createDataObject(Map<String, Object> dataRow, PersonalDataMeta meta) {
        DataObject dataObject = DataObject.create();
        dataObject.setId(this.createIds(dataRow, meta));
        dataObject.setType(meta.getKey());
        return dataObject;
    }

    protected DataSubject createDataSubject(Map<String, Object> dataRow, PersonalDataMeta meta) {
        PersonalDataMeta dsMeta = this.findDataSubjectMeta(meta);
        if (dsMeta != null) {
            DataSubject dataSubject = DataSubject.create();
            dataSubject.setRole(dsMeta.getDataSubjectRole());
            dataSubject.setType(dsMeta.getKey());
            List<KeyValuePair> dsIds = this.createDataSubjectIds(dataRow, dsMeta);
            if (dsIds.isEmpty()) {
                if (this.throwOnMissingDataSubject) {
                    throw new ServiceException((ErrorStatus)CdsErrorStatuses.AUDITLOG_DATA_SUBJECT_MISSING, meta.getKey(), new Object[0]);
                }
                logger.warn("No data subject instance was found.");
            }
            dataSubject.setId(dsIds);
            return dataSubject;
        }
        if (this.throwOnMissingDataSubject) {
            throw new ServiceException((ErrorStatus)CdsErrorStatuses.AUDITLOG_DATA_SUBJECT_MISSING, meta.getKey(), new Object[0]);
        }
        logger.warn("No data subject entity was found for data object {}.", (Object)meta.getKey());
        return null;
    }

    private List<KeyValuePair> createIds(Map<String, Object> dataRow, PersonalDataMeta meta) {
        return this.createIds(dataRow, meta.getKeyNames().stream(), PersonalDataUtils::getKeyAlias);
    }

    private List<KeyValuePair> createDataSubjectIds(Map<String, Object> dataRow, PersonalDataMeta meta) {
        return this.createIds(dataRow, meta.getDataSubjectIds().stream().map(CdsElementDefinition::getName), PersonalDataUtils::getDSIdAlias);
    }

    private List<KeyValuePair> createIds(Map<String, Object> dataRow, Stream<String> keys, UnaryOperator<String> alias) {
        ArrayList<KeyValuePair> ids = new ArrayList<KeyValuePair>();
        keys.forEach(key -> {
            KeyValuePair pair = KeyValuePair.create();
            pair.setKeyName(key);
            Object keyValue = dataRow.get(alias.apply((String)key));
            if (keyValue == null) {
                keyValue = dataRow.get(key);
            }
            pair.setValue(keyValue != null ? keyValue.toString() : null);
            ids.add(pair);
        });
        return ids;
    }

    private PersonalDataMeta findDataSubjectMeta(PersonalDataMeta meta) {
        CdsElement dsAssoc;
        if (meta.isDataSubject()) {
            return meta;
        }
        if ((meta.isDataSubjectDetails() || meta.isOther()) && (dsAssoc = meta.getDataSubjectAssociation()) != null) {
            CdsEntity parent = ((CdsAssociationType)dsAssoc.getType().as(CdsAssociationType.class)).getTarget();
            return this.findDataSubjectMeta(this.getMeta((CdsStructuredType)parent));
        }
        return null;
    }

    protected PersonalDataMeta getMeta(CdsStructuredType type) {
        return this.caches.getMeta(type);
    }
}

