/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.cds;

import com.sap.cds.Result;
import com.sap.cds.ql.CQL;
import com.sap.cds.ql.Select;
import com.sap.cds.ql.StructuredType;
import com.sap.cds.ql.cqn.CqnAnalyzer;
import com.sap.cds.ql.cqn.CqnExpand;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.CqnReference;
import com.sap.cds.ql.cqn.CqnSelect;
import com.sap.cds.ql.cqn.CqnSelectListItem;
import com.sap.cds.ql.cqn.CqnStatement;
import com.sap.cds.ql.cqn.CqnStructuredTypeRef;
import com.sap.cds.ql.cqn.Modifier;
import com.sap.cds.ql.cqn.ResolvedSegment;
import com.sap.cds.reflect.CdsAnnotatable;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.EventContext;
import com.sap.cds.services.cds.ApplicationService;
import com.sap.cds.services.cds.CqnService;
import com.sap.cds.services.handler.EventHandler;
import com.sap.cds.services.handler.annotations.Before;
import com.sap.cds.services.handler.annotations.HandlerOrder;
import com.sap.cds.services.handler.annotations.ServiceName;
import com.sap.cds.services.impl.utils.PathAwareCqnModifier;
import com.sap.cds.services.impl.utils.TargetAwareCqnModifier;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import com.sap.cds.services.utils.model.CdsAnnotations;
import com.sap.cds.util.DataUtils;
import java.util.List;
import java.util.Map;

@ServiceName(value={"*"}, type={ApplicationService.class})
public class SingletonHandler
implements EventHandler {
    @Before(event={"READ", "CREATE", "UPDATE", "UPSERT", "DELETE"})
    @HandlerOrder(value=-10700)
    public void handleSingletons(EventContext context) {
        CqnStatement cqn = (CqnStatement)context.get("cqn");
        ModificationMode mode = ModificationMode.ALL;
        if (cqn.isSelect() || cqn.isInsert()) {
            mode = ModificationMode.IGNORE_LAST;
        } else if (cqn.isUpsert()) {
            mode = ModificationMode.MOVE_LAST;
        }
        SingletonModifier modifier = new SingletonModifier(CqnAnalyzer.create((CdsModel)context.getModel()), (CqnService)context.getService(), context.getTarget(), mode);
        CqnStatement copy = CQL.copy((CqnStatement)cqn, (Modifier)modifier);
        if (copy.isSelect() && SingletonHandler.isSingleton(context.getTarget())) {
            ((Select)copy).limit(1L);
        }
        if (copy.isUpsert() && modifier.getKeysToMove() != null) {
            List entries = copy.asUpsert().entries();
            if (entries.size() != 1) {
                throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.MULTIPLE_SINGLETON_ENTRIES, new Object[0]);
            }
            ((Map)entries.get(0)).putAll(modifier.getKeysToMove());
        }
        context.put("cqn", (Object)copy);
    }

    private static boolean isSingleton(CdsEntity entity) {
        return CdsAnnotations.SINGLETON.isTrue((CdsAnnotatable)entity);
    }

    private static enum ModificationMode {
        ALL,
        IGNORE_LAST,
        MOVE_LAST;

    }

    private static class SingletonModifier
    extends PathAwareCqnModifier {
        private final CqnService service;
        private final ModificationMode mode;
        private Map<String, Object> keysToMove;

        public SingletonModifier(CqnAnalyzer analyzer, CqnService service, CdsEntity target, ModificationMode mode) {
            super(analyzer, target);
            this.service = service;
            this.mode = mode;
        }

        @Override
        protected CqnReference.Segment segment(CqnReference.Segment segment, ResolvedSegment resolved, int position, CqnStructuredTypeRef ref) {
            boolean isLast;
            boolean bl = isLast = position == ref.size() - 1;
            if (isLast && this.mode == ModificationMode.IGNORE_LAST) {
                return segment;
            }
            CdsEntity entity = resolved.entity();
            if (SingletonHandler.isSingleton(entity)) {
                List<String> keyElements = entity.keyElements().map(e -> e.getName()).toList();
                if (keyElements.isEmpty()) {
                    return segment;
                }
                if (resolved.keyValues().size() == keyElements.size()) {
                    return segment;
                }
                StructuredType singletonRef = CQL.to(ref.segments().subList(0, position + 1));
                Result result = this.service.run((CqnSelect)Select.from((StructuredType)singletonRef).columns(keyElements.stream().map(CQL::get)), new Object[0]);
                if (isLast && this.mode == ModificationMode.MOVE_LAST) {
                    if (result.first().isPresent()) {
                        this.keysToMove = result.single();
                    }
                } else {
                    if (result.rowCount() == 1L) {
                        Map singletonKeys = DataUtils.keyValues((CdsEntity)entity, (Map)result.single());
                        return CQL.refSegment((String)segment.id(), (CqnPredicate)CQL.matching((Map)singletonKeys));
                    }
                    return CQL.refSegment((String)segment.id(), (CqnPredicate)CQL.FALSE);
                }
            }
            return segment;
        }

        @Override
        public CqnSelectListItem expand(CqnExpand expand) {
            CdsEntity target = this.getRefTarget(expand.ref());
            if (target != null && SingletonHandler.isSingleton(target)) {
                return CQL.copy((CqnExpand)expand).limit(1L);
            }
            return expand;
        }

        @Override
        protected TargetAwareCqnModifier create(CdsEntity target) {
            return new SingletonModifier(this.analyzer, this.service, target, this.mode);
        }

        public Map<String, Object> getKeysToMove() {
            return this.keysToMove;
        }
    }
}

