/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.draft;

import com.sap.cds.reflect.CdsAssociationType;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsModel;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParentEntityLookup {
    private static final Logger log = LoggerFactory.getLogger(ParentEntityLookup.class);
    private Map<CdsEntity, List<ParentEntityLookupResult>> cachedParentEntities = new ConcurrentHashMap<CdsEntity, List<ParentEntityLookupResult>>();
    private CdsModel model;

    public ParentEntityLookup(CdsModel model) {
        this.model = model;
    }

    public List<ParentEntityLookupResult> lookupParent(CdsEntity child) {
        if (!this.cachedParentEntities.containsKey(child)) {
            ArrayList parentEntities = new ArrayList();
            this.model.entities().forEach(entity -> {
                Stream<CdsElement> compositions = entity.compositions().filter(c -> ((CdsAssociationType)c.getType().as(CdsAssociationType.class)).getTarget() == child);
                compositions.forEach(composition -> {
                    ParentEntityLookupResult result = new ParentEntityLookupResult((CdsEntity)entity, (CdsElement)composition);
                    log.debug("Found {} via {} as parent for {}", new Object[]{entity, composition, child});
                    parentEntities.add(result);
                });
            });
            this.cachedParentEntities.putIfAbsent(child, parentEntities);
        }
        return this.cachedParentEntities.get(child);
    }

    public static class ParentEntityLookupResult {
        private CdsEntity parentEntity;
        private CdsElement composition;

        public ParentEntityLookupResult(CdsEntity parentEntity, CdsElement composition) {
            this.parentEntity = parentEntity;
            this.composition = composition;
        }

        public CdsEntity getParentEntity() {
            return this.parentEntity;
        }

        public CdsElement getComposition() {
            return this.composition;
        }
    }
}

