/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.messaging.message;

import com.sap.cds.reflect.CdsAnnotatable;
import com.sap.cds.reflect.CdsEvent;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.ServiceCatalog;
import com.sap.cds.services.impl.messaging.composite.MessagingCompositeService;
import com.sap.cds.services.messaging.MessagingService;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import com.sap.cds.services.utils.StringUtils;
import com.sap.cds.services.utils.model.CdsAnnotations;
import java.util.List;
import java.util.stream.Collectors;

public class CdsMessagingUtils {
    public static MessagingService getMessagingService(CdsRuntime runtime) {
        ServiceCatalog catalog = runtime.getServiceCatalog();
        MessagingCompositeService compositeService = (MessagingCompositeService)catalog.getService(MessagingCompositeService.class, "MessagingService$Composite");
        if (compositeService != null) {
            return compositeService;
        }
        List services = catalog.getServices(MessagingService.class).collect(Collectors.toList());
        if (services.isEmpty()) {
            return null;
        }
        if (services.size() > 1) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.MULTIPLE_MESSAGINGSERVICE, new Object[0]);
        }
        return (MessagingService)services.get(0);
    }

    public static String getTopic(CdsEvent event) {
        String topic = (String)CdsAnnotations.TOPIC.getOrDefault((CdsAnnotatable)event);
        return StringUtils.isEmpty((String)topic) ? event.getQualifiedName() : topic;
    }
}

