/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.outbox;

import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.Service;
import com.sap.cds.services.impl.ServiceSPI;
import com.sap.cds.services.impl.outbox.InMemoryOutbox;
import com.sap.cds.services.impl.utils.CdsServiceUtils;
import com.sap.cds.services.outbox.OutboxService;
import com.sap.cds.services.request.RequestContext;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;

public class OutboxedServiceInvocationHandler
implements InvocationHandler {
    private final OutboxService outboxService;
    private final Service service;
    private final ServiceSPI serviceSPI;
    private final CdsRuntime runtime;

    public OutboxedServiceInvocationHandler(OutboxService outboxService, Service service, CdsRuntime runtime) {
        this.outboxService = outboxService;
        this.service = service;
        this.serviceSPI = CdsServiceUtils.getServiceSPI(service);
        this.runtime = runtime;
        if (this.serviceSPI == null) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.SERVICE_HAS_NO_SERVICESPI, new Object[]{service.getName()});
        }
    }

    public OutboxService getOutboxService() {
        return this.outboxService;
    }

    public Service getDelegatedService() {
        return this.service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        OutboxService targetOutbox = this.outboxService;
        boolean providerTenantPersistence = this.runtime.getEnvironment().getCdsProperties().getOutbox().getProviderTenant().isEnabled();
        if (!(this.outboxService instanceof InMemoryOutbox) && !providerTenantPersistence && RequestContext.getCurrent((CdsRuntime)this.runtime).getUserInfo().getTenant() == null) {
            targetOutbox = (OutboxService)this.runtime.getServiceCatalog().getService(InMemoryOutbox.class, "OutboxService$InMemory");
        }
        try {
            this.serviceSPI.setOutbox(targetOutbox);
            Object object = method.invoke((Object)this.service, args);
            return object;
        }
        finally {
            this.serviceSPI.setOutbox(null);
        }
    }
}

