/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.persistence;

import com.sap.cds.SessionContext;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.services.EventContext;
import com.sap.cds.services.handler.EventHandler;
import com.sap.cds.services.handler.annotations.Before;
import com.sap.cds.services.handler.annotations.HandlerOrder;
import com.sap.cds.services.handler.annotations.ServiceName;
import com.sap.cds.services.impl.utils.CdsServiceUtils;
import com.sap.cds.services.persistence.PersistenceService;
import com.sap.cds.services.utils.SessionContextUtils;
import com.sap.cds.util.DataUtils;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@ServiceName(value={"*"}, type={PersistenceService.class})
public class ManagedAspectHandler
implements EventHandler {
    @Before(event={"CREATE", "UPDATE", "UPSERT"})
    @HandlerOrder(value=11000)
    public void calculateManagedFields(EventContext context) {
        SessionContext sessionContext = SessionContextUtils.toSessionContext((EventContext)context);
        if (Objects.isNull(sessionContext.getUserContext().getId())) {
            sessionContext.getUserContext().setId("anonymous");
        }
        DataUtils dataUtils = DataUtils.create(() -> sessionContext, (int)7);
        String event = context.getEvent();
        List<Map<String, Object>> entries = CdsServiceUtils.getEntities(context);
        CdsEntity struct = context.getTarget();
        if ("CREATE".equals(event)) {
            dataUtils.processOnInsert((CdsStructuredType)struct, entries);
        } else if ("UPDATE".equals(event)) {
            dataUtils.processOnUpdate((CdsStructuredType)struct, entries, true);
        } else if ("UPSERT".equals(event)) {
            dataUtils.processOnUpdate((CdsStructuredType)struct, entries, true);
        }
    }
}

