/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.runtime;

import com.google.common.reflect.ClassPath;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.Service;
import com.sap.cds.services.ServiceException;
import com.sap.cds.services.environment.ApplicationInfoProvider;
import com.sap.cds.services.environment.PropertiesProvider;
import com.sap.cds.services.environment.ServiceBindingProvider;
import com.sap.cds.services.impl.runtime.CdsRuntimeImpl;
import com.sap.cds.services.messages.LocalizedMessageProvider;
import com.sap.cds.services.runtime.AuthenticationInfoProvider;
import com.sap.cds.services.runtime.CdsModelProvider;
import com.sap.cds.services.runtime.CdsProvider;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.runtime.CdsRuntimeConfiguration;
import com.sap.cds.services.runtime.CdsRuntimeConfigurer;
import com.sap.cds.services.runtime.ExtendedServiceLoader;
import com.sap.cds.services.runtime.FeatureTogglesInfoProvider;
import com.sap.cds.services.runtime.ParameterInfoProvider;
import com.sap.cds.services.runtime.UserInfoProvider;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import com.sap.cds.services.utils.StringUtils;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CdsRuntimeConfigurerImpl
implements CdsRuntimeConfigurer {
    private static final Logger logger = LoggerFactory.getLogger(CdsRuntimeConfigurerImpl.class);
    private final CdsRuntimeImpl runtime;
    private final List<CdsRuntimeConfiguration> configurations = new ArrayList<CdsRuntimeConfiguration>();
    private ConfigurationPhase current = ConfigurationPhase.CONFIGURATIONS;

    public CdsRuntimeConfigurerImpl(PropertiesProvider propertiesProvider) {
        this.runtime = new CdsRuntimeImpl(propertiesProvider);
        ExtendedServiceLoader.loadAll(CdsRuntimeConfiguration.class).forEachRemaining(this::configuration);
    }

    public CdsRuntime getCdsRuntime() {
        return this.runtime;
    }

    public CdsRuntimeConfigurer configuration(CdsRuntimeConfiguration configuration) {
        this.checkPhase(ConfigurationPhase.CONFIGURATIONS);
        this.configurations.add(configuration);
        return this;
    }

    public CdsRuntimeConfigurer environmentConfigurations() {
        this.checkPhase(ConfigurationPhase.ENVIRONMENT);
        this.sortConfigurations();
        this.configurations.forEach(c -> c.environment((CdsRuntimeConfigurer)this));
        return this;
    }

    public CdsRuntimeConfigurer environment(ServiceBindingProvider provider) {
        return this.provider((CdsProvider<?>)provider);
    }

    public CdsRuntimeConfigurer environment(ApplicationInfoProvider provider) {
        return this.provider((CdsProvider<?>)provider);
    }

    public CdsRuntimeConfigurer cdsModel() {
        this.checkPhase(ConfigurationPhase.MODEL);
        try {
            return this.cdsModel(this.runtime.getEnvironment().getCdsProperties().getModel().getCsnPath());
        }
        catch (ServiceException e) {
            if (e.getErrorStatus().equals(CdsErrorStatuses.INVALID_CSN)) {
                logger.debug("Failed to load default CDS model", (Throwable)e);
                logger.warn("Initialized empty CDS model, because default CDS model could not be loaded");
                return this.cdsModel((String)null);
            }
            throw e;
        }
    }

    public CdsRuntimeConfigurer cdsModel(String csnPath) {
        this.checkPhase(ConfigurationPhase.MODEL);
        this.runtime.setCdsModel(csnPath);
        return this;
    }

    public CdsRuntimeConfigurer cdsModel(CdsModel model) {
        this.checkPhase(ConfigurationPhase.MODEL);
        this.runtime.setCdsModel(model);
        return this;
    }

    public CdsRuntimeConfigurer serviceConfigurations() {
        this.checkPhase(ConfigurationPhase.SERVICES);
        this.sortConfigurations();
        this.configurations.forEach(c -> c.services((CdsRuntimeConfigurer)this));
        return this;
    }

    public CdsRuntimeConfigurer service(Service service) {
        this.checkPhase(ConfigurationPhase.SERVICES);
        this.runtime.registerService(service);
        return this;
    }

    public CdsRuntimeConfigurer eventHandlerConfigurations() {
        this.checkPhase(ConfigurationPhase.EVENTHANDLERS);
        this.sortConfigurations();
        this.configurations.forEach(c -> c.eventHandlers((CdsRuntimeConfigurer)this));
        return this;
    }

    public CdsRuntimeConfigurer eventHandler(Object handler) {
        this.checkPhase(ConfigurationPhase.EVENTHANDLERS);
        return this.eventHandler(handler.getClass(), () -> handler);
    }

    public <T> CdsRuntimeConfigurer eventHandler(Class<T> handlerClass, Supplier<T> handlerFactory) {
        this.checkPhase(ConfigurationPhase.EVENTHANDLERS);
        this.runtime.registerEventHandler(handlerClass, handlerFactory);
        return this;
    }

    public CdsRuntimeConfigurer packageScan(String packageName) throws IOException {
        this.checkPhase(ConfigurationPhase.EVENTHANDLERS);
        if (StringUtils.isEmpty((String)packageName)) {
            return this;
        }
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        MethodType mt = MethodType.methodType(Void.TYPE);
        ClassLoader classloader = Thread.currentThread().getContextClassLoader();
        for (ClassPath.ClassInfo classInfo : ClassPath.from((ClassLoader)classloader).getAllClasses()) {
            if (!classInfo.getName().startsWith(packageName)) continue;
            try {
                Class<?> testClass = Class.forName(classInfo.getName());
                MethodHandle defaultCtor = lookup.findConstructor(testClass, mt);
                Supplier<Object> supplier = () -> {
                    try {
                        return defaultCtor.invoke();
                    }
                    catch (Throwable e) {
                        throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.HANDLER_FAILED, new Object[]{testClass.getName(), e});
                    }
                };
                logger.info("Found potential Event Handler class {}", (Object)testClass.getName());
                this.eventHandler(testClass, supplier);
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException reflectiveOperationException) {}
        }
        return this;
    }

    public CdsRuntimeConfigurer providerConfigurations() {
        this.checkPhase(ConfigurationPhase.PROVIDERS);
        this.sortConfigurations();
        this.configurations.forEach(c -> c.providers((CdsRuntimeConfigurer)this));
        return this;
    }

    public CdsRuntimeConfigurer provider(CdsModelProvider provider) {
        return this.provider((CdsProvider<?>)provider);
    }

    public CdsRuntimeConfigurer provider(AuthenticationInfoProvider provider) {
        return this.provider((CdsProvider<?>)provider);
    }

    public CdsRuntimeConfigurer provider(UserInfoProvider provider) {
        return this.provider((CdsProvider<?>)provider);
    }

    public CdsRuntimeConfigurer provider(ParameterInfoProvider provider) {
        return this.provider((CdsProvider<?>)provider);
    }

    public CdsRuntimeConfigurer provider(LocalizedMessageProvider provider) {
        return this.provider((CdsProvider<?>)provider);
    }

    public CdsRuntimeConfigurer provider(FeatureTogglesInfoProvider provider) {
        return this.provider((CdsProvider<?>)provider);
    }

    public CdsRuntimeConfigurer provider(CdsProvider<?> provider) {
        if (provider instanceof ServiceBindingProvider || provider instanceof ApplicationInfoProvider) {
            this.checkPhase(ConfigurationPhase.ENVIRONMENT);
        } else {
            this.checkPhase(ConfigurationPhase.PROVIDERS);
        }
        this.runtime.registerProvider(provider);
        return this;
    }

    public CdsRuntime complete() {
        this.current = ConfigurationPhase.COMPLETE;
        return this.runtime;
    }

    private void checkPhase(ConfigurationPhase phase) {
        if (this.current == ConfigurationPhase.COMPLETE) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.CONFIGURER_COMPLETED, new Object[0]);
        }
        if (this.current.ordinal() > phase.ordinal()) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.INVALID_CONFIGURATION_PHASE, new Object[]{phase.name(), this.current.name()});
        }
        this.current = phase;
    }

    private void sortConfigurations() {
        Collections.sort(this.configurations, (c1, c2) -> Integer.compare(c1.order(), c2.order()));
    }

    private static enum ConfigurationPhase {
        CONFIGURATIONS,
        ENVIRONMENT,
        MODEL,
        SERVICES,
        EVENTHANDLERS,
        PROVIDERS,
        COMPLETE;

    }
}

