/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.utils;

import com.sap.cds.ql.cqn.Path;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.EventContext;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import java.util.Objects;
import org.slf4j.helpers.MessageFormatter;

public class ValidatorErrorUtils {
    private ValidatorErrorUtils() {
    }

    public static void handleValidationError(EventContext context, Path path, CdsElement element, CdsErrorStatuses statuses, Object ... args) {
        ValidatorErrorUtils.handleValidationError(context, false, path, element, statuses, args);
    }

    public static void handleValidationError(EventContext context, boolean forceException, Path path, CdsElement element, CdsErrorStatuses statuses, Object ... args) {
        if (forceException || !context.getCdsRuntime().getEnvironment().getCdsProperties().getErrors().isCombined()) {
            throw new ErrorStatusException((ErrorStatus)statuses, args).messageTarget(path, element);
        }
        context.getMessages().error(ValidatorErrorUtils.getLocalizedMessage(context, (ErrorStatus)statuses, args), new Object[0]).code(statuses.getCodeString()).target(path, element);
    }

    private static String getLocalizedMessage(EventContext context, ErrorStatus errorStatus, Object ... args) {
        String localized = context.getCdsRuntime().getLocalizedMessage(errorStatus.getCodeString(), args, context.getParameterInfo().getLocale());
        if (Objects.equals(localized, errorStatus.getCodeString())) {
            return MessageFormatter.arrayFormat((String)errorStatus.getDescription(), (Object[])args).getMessage();
        }
        return localized;
    }
}

