/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.handlerregistry;

import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.EventContext;
import com.sap.cds.services.Service;
import com.sap.cds.services.ServiceCatalog;
import com.sap.cds.services.handler.Handler;
import com.sap.cds.services.impl.handlerregistry.AnnotatedHandlerMethodsFinder;
import com.sap.cds.services.impl.handlerregistry.AnnotationDescriptor;
import com.sap.cds.services.impl.handlerregistry.EventPredicateTools;
import com.sap.cds.services.impl.handlerregistry.HandlerDescriptor;
import com.sap.cds.services.impl.handlerregistry.resolver.ArgumentResolver;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import com.sap.cds.services.utils.StringUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HandlerRegistryTools {
    private static final Logger logger = LoggerFactory.getLogger(HandlerRegistryTools.class);

    private HandlerRegistryTools() {
    }

    public static <T> void registerInstance(Object instance, Service service) {
        AnnotatedHandlerMethodsFinder ahmf = new AnnotatedHandlerMethodsFinder(instance.getClass());
        for (HandlerDescriptor hd : ahmf.getHandlerDescriptors()) {
            for (AnnotationDescriptor ad : hd.getAnnotations()) {
                HandlerRegistryTools.register(ad, hd, () -> instance, Stream.of(service), false);
            }
        }
    }

    public static <T> void registerClass(Class<T> handlerClass, Supplier<T> factory, ServiceCatalog serviceCatalog) {
        AnnotatedHandlerMethodsFinder ahmf = new AnnotatedHandlerMethodsFinder(handlerClass);
        for (HandlerDescriptor hd : ahmf.getHandlerDescriptors()) {
            for (AnnotationDescriptor ad : hd.getAnnotations()) {
                HandlerRegistryTools.register(ad, hd, factory, serviceCatalog.getServices(), true);
            }
        }
    }

    private static <T> void register(AnnotationDescriptor ad, HandlerDescriptor hd, Supplier<T> factory, Stream<Service> availableServices, boolean requireServiceConfig) {
        String[] entities;
        String[] events;
        List<Service> services;
        Collection<String> names;
        String[] theDefaultNames = hd.getDefaultServiceNames();
        String[] theNames = ad.getServiceNames();
        if (StringUtils.notEmpty((String[])theNames) != null) {
            names = EventPredicateTools.toMatchCollection(theNames);
        } else if (StringUtils.notEmpty((String[])theDefaultNames) != null) {
            names = EventPredicateTools.toMatchCollection(theDefaultNames);
        } else {
            if (requireServiceConfig) {
                throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.HANDLER_SERVICE_REQUIRED, new Object[]{hd.getMethodName()});
            }
            names = Collections.emptyList();
        }
        Class<?>[] theDefaultTypes = hd.getDefaultServiceTypes();
        Class<?>[] theTypes = ad.getServiceTypes();
        List<Class<Object>> types = theTypes.length > 0 ? Arrays.asList(theTypes) : (theDefaultTypes.length > 0 ? Arrays.asList(theDefaultTypes) : Collections.emptyList());
        Stream<Service> theServices = availableServices;
        if (!names.isEmpty()) {
            theServices = theServices.filter(s -> names.contains(s.getName()));
        }
        if (!types.isEmpty()) {
            theServices = theServices.filter(s -> types.stream().anyMatch(t -> t.isAssignableFrom(s.getClass())));
        }
        if ((services = theServices.collect(Collectors.toList())).isEmpty()) {
            logger.warn("Failed to register handler method '" + hd.getMethodName() + "': Could not find any matching service.");
            return;
        }
        if (StringUtils.notEmpty((String[])ad.getEvents()) == null) {
            HashSet<String> eventSet = new HashSet<String>();
            for (ArgumentResolver resolver : hd.getArgumentResolvers()) {
                eventSet.addAll(Arrays.asList(resolver.indicateEvents()));
            }
            events = eventSet.toArray(new String[0]);
            if (StringUtils.notEmpty((String[])events) == null) {
                throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.HANDLER_EVENT_REQUIRED, new Object[]{hd.getMethodName()});
            }
        } else {
            events = ad.getEvents();
        }
        if (StringUtils.notEmpty((String[])ad.getEntities()) == null) {
            HashSet<String> entity = new HashSet<String>();
            for (ArgumentResolver resolver : hd.getArgumentResolvers()) {
                entity.addAll(Arrays.asList(resolver.indicateEntities()));
            }
            entities = entity.toArray(new String[0]);
        } else {
            entities = ad.getEntities();
        }
        services.forEach(service -> {
            switch (ad.getPhase()) {
                case BEFORE: {
                    service.before(events, entities, hd.getOrder(), new DescribedHandler(hd, factory));
                    break;
                }
                case ON: {
                    service.on(events, entities, hd.getOrder(), new DescribedHandler(hd, factory));
                    break;
                }
                case AFTER: {
                    service.after(events, entities, hd.getOrder(), new DescribedHandler(hd, factory));
                    break;
                }
            }
        });
    }

    private static RuntimeException throwAsUnchecked(Throwable throwable) {
        HandlerRegistryTools._throwAsUnchecked(throwable);
        return null;
    }

    private static <T extends Throwable> void _throwAsUnchecked(Throwable throwable) throws T {
        throw throwable;
    }

    private static final class DescribedHandler<T>
    implements Handler {
        private final HandlerDescriptor hd;
        private final Supplier<T> factory;

        DescribedHandler(HandlerDescriptor hd, Supplier<T> factory) {
            this.hd = hd;
            this.factory = factory;
        }

        public void process(EventContext context) {
            try {
                List<ArgumentResolver> argumentResolvers = this.hd.getArgumentResolvers();
                Object[] arguments = new Object[argumentResolvers.size() + 1];
                arguments[0] = this.factory.get();
                for (int i = 0; i < argumentResolvers.size(); ++i) {
                    arguments[i + 1] = argumentResolvers.get(i).resolve(context);
                }
                Object returnValue = this.hd.getMethodHandle().invoke(arguments);
                this.hd.getReturnResolver().resolve(returnValue, context);
            }
            catch (Throwable e) {
                throw HandlerRegistryTools.throwAsUnchecked(e);
            }
        }

        public String toString() {
            return this.hd.getMethodName();
        }
    }
}

