/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.outbox;

import com.sap.cds.services.EventContext;
import com.sap.cds.services.changeset.ChangeSetContext;
import com.sap.cds.services.changeset.ChangeSetListener;
import com.sap.cds.services.impl.outbox.AbstractOutboxService;
import com.sap.cds.services.outbox.OutboxMessageEventContext;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.utils.ErrorStatusException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemoryOutbox
extends AbstractOutboxService {
    private static final Logger logger = LoggerFactory.getLogger(InMemoryOutbox.class);

    public InMemoryOutbox(String name, CdsRuntime runtime) {
        super(name, runtime);
    }

    @Override
    protected void submit(final OutboxMessageEventContext context) {
        logger.debug("Submitting outbox message with outbox event '{}'", (Object)context.getEvent());
        final boolean emitDuringChangeSetContext = context.getCdsRuntime().getEnvironment().getCdsProperties().getOutbox().getInMemory().isEmitDuringChangeSetContext();
        final ChangeSetContext changeSet = context.getChangeSetContext();
        changeSet.register(new ChangeSetListener(){

            public void beforeClose() {
                if (!changeSet.isMarkedForCancel() && emitDuringChangeSetContext) {
                    InMemoryOutbox.this.publishMessage(context);
                }
            }

            public void afterClose(boolean completed) {
                if (!emitDuringChangeSetContext && completed) {
                    InMemoryOutbox.this.publishMessage(context);
                }
            }
        });
    }

    private void publishMessage(OutboxMessageEventContext submitContext) throws ErrorStatusException {
        logger.debug("Publishing outbox message with outbox event '{}'", (Object)submitContext.getEvent());
        OutboxMessageEventContext publishContext = OutboxMessageEventContext.create((String)submitContext.getEvent());
        publishContext.setIsInbound(true);
        publishContext.setTimestamp(submitContext.getTimestamp());
        publishContext.setMessage(submitContext.getMessage());
        submitContext.getService().emit((EventContext)publishContext);
    }
}

