/**************************************************************************
 * (C) 2019-2023 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.services.impl.application;

import com.sap.cds.services.application.ApplicationLifecycleService;
import com.sap.cds.services.auditlog.AuditLogService;
import com.sap.cds.services.runtime.CdsRuntimeConfiguration;
import com.sap.cds.services.runtime.CdsRuntimeConfigurer;

public class ApplicationLifecycleServiceConfiguration implements CdsRuntimeConfiguration {

	@Override
	public void services(CdsRuntimeConfigurer configurer) {
		configurer.service(new ApplicationLifecycleServiceImpl(ApplicationLifecycleService.DEFAULT_NAME));
	}

	@Override
	public void eventHandlers(CdsRuntimeConfigurer configurer) {
		configurer.eventHandler(new ApplicationLifecycleBuildInfoHandler());
		configurer.eventHandler(new ErrorResponseHandler());
		if (configurer.getCdsRuntime().getEnvironment().getCdsProperties().getAuditLog().getStandardEvents()
				.isEnabled()) {
			AuditLogService als = configurer.getCdsRuntime().getServiceCatalog().getService(
					AuditLogService.class, AuditLogService.DEFAULT_NAME);
			configurer.eventHandler(new SecurityAuditEventHandler(als));
		}
	}
}
