package com.sap.cds.services.impl.auditlog.events;

import com.sap.cds.CdsData;
import com.sap.cds.Struct;
import com.sap.cds.ql.CdsName;
import com.sap.cds.services.environment.ApplicationInfo;
import com.sap.cds.services.impl.auditlog.events.AuditEvent.Event.Metadata;
import com.sap.cds.services.impl.auditlog.events.AuditEvent.Event.Metadata.AppContext;
import com.sap.cds.services.request.ParameterInfo;
import com.sap.cds.services.request.RequestContext;
import com.sap.cds.services.runtime.CdsRuntime;

@CdsName("com.sap.auditlog.events.AuditEvent")
public interface AuditEvent extends CdsData {
	String EVENT = "event";

	String DATA = "data";

	Event getEvent();

	void setEvent(Event event);

	static AuditEvent create() {
		return Struct.create(AuditEvent.class);
	}

	static AuditEvent create(CdsRuntime runtime) {
		RequestContext context = RequestContext.getCurrent(runtime);
		AuditEvent auditlogEvent = Struct.create(AuditEvent.class);

		Event event = Event.create();
		auditlogEvent.setEvent(event);

		Metadata meta = Metadata.create();

		ParameterInfo pInfo = context.getParameterInfo();

		// ip
		String ip = pInfo.getHeader("x-forwarded-for");
		ip = null == ip ? pInfo.getHeader("x-real-ip") : ip;
		meta.setSourceIp(ip);

		meta.setCorrelationId(pInfo.getCorrelationId());
		meta.setPrincipalId(context.getUserInfo().getName());
		meta.setTenantId(context.getUserInfo().getTenant());

		AppContext appContext = AppContext.create();
		ApplicationInfo appInfo = runtime.getEnvironment().getApplicationInfo();
		// throws Exception on K8s
		// TODO make values in K8s configurable
		if (!appInfo.getClass().getName().equals("com.sap.cds.feature.k8s.K8sApplicationInfoProvider.K8sApplicationInfo")) {
			appContext.setName(appInfo.getName());
			meta.setAppContext(appContext);
			meta.setAppId(appInfo.getId());
		}

		event.setMetadata(meta);

		return auditlogEvent;
	}

	interface Event extends CdsData {
		String METADATA = "metadata";

		Metadata getMetadata();

		void setMetadata(Metadata metadata);

		static Event create() {
			return Struct.create(Event.class);
		}

		interface Metadata extends CdsData {
			// currently not supported
			// String TS = "ts";

			String SOURCE_IP = "sourceIp";

			String PRINCIPAL_ID = "principalId";

			String APP_ID = "appId";

			String APP_CONTEXT = "appContext";

			// Instant getTs();

			// void setTs(Instant ts);

			String getSourceIp();

			void setSourceIp(String sourceIp);

			String getPrincipalId();

			void setPrincipalId(String principalId);

			String getAppId();

			void setAppId(String appId);

			String getTenantId();

			void setTenantId(String tenantId);

			String getCorrelationId();

			void setCorrelationId(String correlationId);

			AppContext getAppContext();

			void setAppContext(AppContext appContext);

			static Metadata create() {
				return Struct.create(Metadata.class);
			}

			interface AppContext extends CdsData {
				String NAME = "name";

				String getName();

				void setName(String name);

				static AppContext create() {
					return Struct.create(AppContext.class);
				}
			}
		}
	}

}
