/**************************************************************************
 * (C) 2019-2021 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.services.impl.environment;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import com.sap.cds.services.environment.ServiceBindingProvider;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cloud.environment.servicebinding.api.DefaultServiceBindingAccessor;
import com.sap.cloud.environment.servicebinding.api.ServiceBinding;
import com.sap.cloud.environment.servicebinding.api.ServiceBindingAccessor;
import com.sap.cloud.environment.servicebinding.api.SimpleServiceBindingCache;

public class DefaultServiceBindingProvider implements ServiceBindingProvider {

	private final static Object LOCK = new Object();
	private final CdsRuntime runtime;
	private List<ServiceBinding> bindings;

	public DefaultServiceBindingProvider(CdsRuntime runtime) {
		this.runtime = runtime;
	}

	@Override
	public Stream<ServiceBinding> get() {
		if(bindings == null) {
			bindings = loadBindings();
		}
		return bindings.stream();
	}

	private List<ServiceBinding> loadBindings() {
		// lock, in case differently configured runtimes are initialized in parallel -> this might happen in tests
		// for visibility of service bindings in other libraries outside CAP the last set configured path wins
		// in productive applications this code is usually executed exactly once
		synchronized (LOCK) {
			ServiceBindingAccessor accessor = DefaultServiceBindingAccessor.getInstance();
			if (accessor instanceof SimpleServiceBindingCache cache) {
				cache.invalidate();
			}
			DefaultEnvFileServiceBindingLoader.configuredPath = runtime.getEnvironment().getCdsProperties().getEnvironment().getLocal().getDefaultEnvPath();
			return accessor.getServiceBindings().stream().collect(Collectors.toList());
		}
	}

}
