package com.sap.cds.services.impl.environment;

import java.util.HashMap;
import java.util.Map;

import com.sap.cds.services.environment.ApplicationInfo;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.runtime.CdsRuntimeAware;
import com.sap.cds.services.utils.info.CdsInfo;

public class EnvironmentInfo implements CdsInfo, CdsRuntimeAware {

	private CdsRuntime runtime;

	@Override
	public void setCdsRuntime(CdsRuntime runtime) {
		this.runtime = runtime;
	}

	@Override
	public String name() {
		return "environment";
	}

	@Override
	public Map<String, Map<String, Object>> info(Details details) {
		Map<String, Map<String, Object>> environment = new HashMap<>();
		Map<String, Object> applicationInfo = new HashMap<>();
		Map<String, Object> serviceBindings = new HashMap<>();
		environment.put("applicationInfo", applicationInfo);
		environment.put("serviceBindings", serviceBindings);

		ApplicationInfo info = runtime.getEnvironment().getApplicationInfo();
		applicationInfo.put("name", info.getName());
		applicationInfo.put("id", info.getId());
		if(details.compareTo(Details.MEDIUM) >= 0) {
			applicationInfo.put("url", info.getUrl());
		}

		runtime.getEnvironment().getServiceBindings().forEach(binding -> {
			Map<String, Object> serviceBinding = new HashMap<>();
			serviceBindings.put(binding.getName().get(), serviceBinding);
			serviceBinding.put("name", binding.getName().get());
			serviceBinding.put("service", binding.getServiceName().get());
			if(binding.getServicePlan().isPresent()) {
				serviceBinding.put("servicePlan", binding.getServicePlan().get());
			}
			serviceBinding.put("tags", binding.getTags());
		});

		return environment;
	}

}
