/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.aot;

import com.sap.cds.CdsData;
import com.sap.cds.ql.StructuredType;
import com.sap.cds.services.EventContext;
import com.sap.cds.services.Service;
import com.sap.cds.services.handler.EventHandler;
import com.sap.cds.services.handler.annotations.After;
import com.sap.cds.services.handler.annotations.Before;
import com.sap.cds.services.handler.annotations.On;
import com.sap.cds.services.impl.EventContextSPI;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Executable;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.hosted.RuntimeProxyCreation;
import org.graalvm.nativeimage.hosted.RuntimeReflection;

public class CdsAotFeature
implements Feature {
    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        access.registerSubtypeReachabilityHandler((duringAccess, clazz) -> {
            if (clazz.isInterface() && !clazz.equals(EventContext.class) && !clazz.equals(EventContextSPI.class)) {
                RuntimeProxyCreation.register((Class[])new Class[]{clazz});
                RuntimeProxyCreation.register((Class[])new Class[]{clazz, EventContextSPI.class});
            }
        }, EventContext.class);
        access.registerSubtypeReachabilityHandler((duringAccess, clazz) -> {
            if (clazz.isInterface()) {
                RuntimeProxyCreation.register((Class[])new Class[]{clazz});
            }
        }, CdsData.class);
        access.registerSubtypeReachabilityHandler((duringAccess, clazz) -> {
            if (clazz.isInterface() && !clazz.equals(StructuredType.class)) {
                RuntimeProxyCreation.register((Class[])new Class[]{clazz});
            }
        }, StructuredType.class);
        try {
            Iterator<URL> resources = ClassLoader.getSystemResources("META-INF/cds4j-codegen/services.generated").asIterator();
            while (resources.hasNext()) {
                InputStream generatedInput = resources.next().openStream();
                try {
                    if (generatedInput == null) continue;
                    try (BufferedReader reader = new BufferedReader(new InputStreamReader(generatedInput, StandardCharsets.UTF_8));){
                        reader.lines().forEach(this::registerServiceProxyForReflection);
                    }
                }
                finally {
                    if (generatedInput == null) continue;
                    generatedInput.close();
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Could not load generated service interfaces", e);
        }
        access.registerSubtypeReachabilityHandler((duringAccess, clazz) -> this.registerEventHandlersForReflection((Class<?>)clazz), EventHandler.class);
        access.registerSubtypeReachabilityHandler((duringAccess, clazz) -> this.registerEventHandlersForReflection((Class<?>)clazz), Service.class);
    }

    private void registerEventHandlersForReflection(Class<?> clazz) {
        for (Method m : clazz.getDeclaredMethods()) {
            if (m.isAnnotationPresent(Before.class) || m.isAnnotationPresent(On.class) || m.isAnnotationPresent(After.class)) {
                RuntimeReflection.register((Executable[])new Executable[]{m});
                continue;
            }
            RuntimeReflection.registerAsQueried((Executable[])new Executable[]{m});
        }
    }

    private void registerServiceProxyForReflection(String className) {
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Class<?> clazz = loader.loadClass(className);
            RuntimeReflection.register((Class[])new Class[]{clazz});
            for (Method method : clazz.getDeclaredMethods()) {
                RuntimeReflection.register((Executable[])new Executable[]{method});
            }
            for (GenericDeclaration genericDeclaration : clazz.getDeclaredClasses()) {
                if (!((Class)genericDeclaration).isInterface()) continue;
                RuntimeReflection.register((Class[])new Class[]{genericDeclaration});
                RuntimeProxyCreation.register((Class[])new Class[]{genericDeclaration});
            }
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Could not find generated service interface " + className, e);
        }
    }
}

