/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.cds;

import com.sap.cds.Result;
import com.sap.cds.ql.cqn.CqnDelete;
import com.sap.cds.ql.cqn.CqnInsert;
import com.sap.cds.ql.cqn.CqnSelect;
import com.sap.cds.ql.cqn.CqnStatement;
import com.sap.cds.ql.cqn.CqnStructuredTypeRef;
import com.sap.cds.ql.cqn.CqnUpdate;
import com.sap.cds.ql.cqn.CqnUpsert;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.reflect.CdsService;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.EventContext;
import com.sap.cds.services.Service;
import com.sap.cds.services.handler.annotations.Before;
import com.sap.cds.services.handler.annotations.HandlerOrder;
import com.sap.cds.services.handler.annotations.On;
import com.sap.cds.services.impl.cds.TypedCqnServiceInvocationHandler;
import com.sap.cds.services.request.RequestContext;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import com.sap.cds.services.utils.model.CdsModelUtils;
import com.sap.cds.services.utils.services.AbstractCqnService;
import com.sap.cds.util.ProjectionResolver;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Map;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractCdsDefinedService
extends AbstractCqnService {
    private static final Logger logger = LoggerFactory.getLogger(AbstractCdsDefinedService.class);
    private final String definitionName;

    protected AbstractCdsDefinedService(String name, String model, CdsRuntime runtime) {
        super(name, runtime);
        this.definitionName = model != null ? model : name;
        runtime.getCdsModel().getService(this.definitionName);
    }

    public CdsService getDefinition() {
        return RequestContext.getCurrent((CdsRuntime)this.runtime).getModel().getService(this.definitionName);
    }

    public Result run(CqnSelect select, Map<String, Object> namedValues) {
        return select.from().isRef() ? this.runProjected(select, resolved -> super.run(resolved, namedValues)) : super.run(select, namedValues);
    }

    public Result run(CqnInsert insert) {
        return this.runProjected(insert, resolved -> super.run(resolved));
    }

    public Result run(CqnUpsert upsert) {
        return this.runProjected(upsert, resolved -> super.run(resolved));
    }

    public Result run(CqnUpdate update, Iterable<Map<String, Object>> valueSets) {
        return this.runProjected(update, resolved -> super.run(resolved, valueSets));
    }

    public Result run(CqnDelete delete, Iterable<Map<String, Object>> valueSets) {
        return this.runProjected(delete, resolved -> super.run(resolved, valueSets));
    }

    private <T extends CqnStatement> Result runProjected(T statement, Function<T, Result> run) {
        logger.debug("CQN >>{}<<", statement);
        CdsModel model = RequestContext.getCurrent((CdsRuntime)this.runtime).getModel();
        CdsModelUtils.getEntityPath((CqnStructuredTypeRef)statement.ref(), (CdsModel)model);
        ProjectionResolver resolver = ProjectionResolver.create((CdsModel)model, statement).condition((previous, current) -> {
            CdsEntity rootEntity = CdsModelUtils.getEntityPath((CqnStructuredTypeRef)current.ref(), (CdsModel)model).rootEntity();
            return rootEntity.getQualifier().equals(this.definitionName);
        }).resolveAll();
        logger.debug("CQN (projected) >>{}<<", (Object)resolver.getResolvedStatement());
        Result result = run.apply(resolver.getResolvedStatement());
        return result == null ? result : resolver.transform(result);
    }

    @Before
    @HandlerOrder(value=-11000)
    private void checkEntityFitsService(EventContext context) {
        String serviceName;
        String entityQualifier;
        if (context.getTarget() != null && !(entityQualifier = context.getTarget().getQualifier()).equals(serviceName = this.downcast(context.getService()).getDefinition().getQualifiedName()) && !entityQualifier.equals("DRAFT")) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.MISDIRECTED_ENTITY, new Object[]{serviceName, context.getTarget().getQualifiedName()});
        }
    }

    private AbstractCdsDefinedService downcast(Service service) {
        InvocationHandler invocationHandler;
        if (Proxy.isProxyClass(service.getClass()) && (invocationHandler = Proxy.getInvocationHandler(service)) instanceof TypedCqnServiceInvocationHandler) {
            TypedCqnServiceInvocationHandler proxyHandler = (TypedCqnServiceInvocationHandler)invocationHandler;
            return this.downcast(proxyHandler.getDelegatedService());
        }
        return (AbstractCdsDefinedService)service;
    }

    @On
    @HandlerOrder(value=0x7FFFFFFE)
    private void autoCompleteDeclaredEvents(EventContext context) {
        if (this.getDefinition().events().anyMatch(e -> context.getEvent().equals(e.getName()))) {
            context.setCompleted();
        }
    }
}

