/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.cds;

import com.google.common.annotations.VisibleForTesting;
import com.sap.cds.services.Service;
import com.sap.cds.services.cds.CqnService;
import com.sap.cds.services.impl.ServiceSPI;
import com.sap.cds.services.impl.cds.AbstractCdsDefinedService;
import com.sap.cds.services.impl.cds.TypedCqnServiceInvocationHandler;
import com.sap.cds.services.impl.utils.CdsServiceUtils;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypedCqnServiceFactory {
    private static final Logger logger = LoggerFactory.getLogger(TypedCqnServiceFactory.class);
    private static final Map<String, Class<? extends CqnService>> generatedServices = new HashMap<String, Class<? extends CqnService>>();

    private TypedCqnServiceFactory() {
    }

    public static Service createProxyIfAvailable(Service service) {
        AbstractCdsDefinedService cdsDefinedService;
        String serviceName;
        if (service instanceof AbstractCdsDefinedService && generatedServices.containsKey(serviceName = (cdsDefinedService = (AbstractCdsDefinedService)service).getDefinition().getQualifiedName())) {
            CqnService proxy = TypedCqnServiceFactory.createProxy(generatedServices.get(serviceName), (CqnService)cdsDefinedService);
            ServiceSPI serviceSPI = CdsServiceUtils.getServiceSPI((Service)cdsDefinedService);
            if (serviceSPI != null) {
                serviceSPI.setDelegator((Service)proxy);
            }
            return proxy;
        }
        return service;
    }

    @VisibleForTesting
    static <T extends CqnService> T createProxy(Class<T> type, CqnService service) {
        String proxyName;
        Set<Class<Class<?>>> serviceInterfaces = TypedCqnServiceFactory.getAllInterfaces(service.getClass());
        Class<?> exactlyMatchingProxy = null;
        for (Class<?> proxyCandidate : type.getDeclaredClasses()) {
            if (!proxyCandidate.isInterface()) continue;
            Set<Class<Class<Class<?>>>> candidateInterfaces = TypedCqnServiceFactory.getAllInterfaces(proxyCandidate);
            candidateInterfaces.remove(type);
            if (!candidateInterfaces.containsAll(serviceInterfaces) || !serviceInterfaces.containsAll(candidateInterfaces)) continue;
            exactlyMatchingProxy = proxyCandidate;
            break;
        }
        LinkedHashSet<Class<T>> proxyInterfaces = new LinkedHashSet<Class<T>>();
        if (exactlyMatchingProxy != null) {
            proxyInterfaces.add(exactlyMatchingProxy);
            proxyName = exactlyMatchingProxy.getName();
        } else {
            proxyInterfaces.addAll(serviceInterfaces);
            proxyInterfaces.add(type);
            proxyName = type.getName();
        }
        logger.debug("Wrapped service {} with generated interface {}", (Object)service.getName(), (Object)proxyName);
        return (T)((CqnService)Proxy.newProxyInstance(type.getClassLoader(), proxyInterfaces.toArray(new Class[0]), (InvocationHandler)new TypedCqnServiceInvocationHandler(service, type)));
    }

    private static Set<Class<?>> getAllInterfaces(Class<?> clazz) {
        LinkedHashSet interfaces = new LinkedHashSet();
        do {
            for (Class<?> i : clazz.getInterfaces()) {
                interfaces.add(i);
                interfaces.addAll(TypedCqnServiceFactory.getAllInterfaces(i));
            }
        } while ((clazz = clazz.getSuperclass()) != null);
        return interfaces;
    }

    static {
        try {
            Iterator<URL> resources = ClassLoader.getSystemResources("META-INF/cds4j-codegen/services.generated").asIterator();
            while (resources.hasNext()) {
                InputStream generatedInput = resources.next().openStream();
                try {
                    if (generatedInput == null) continue;
                    ClassLoader cl = Thread.currentThread().getContextClassLoader();
                    for (String className : IOUtils.readLines((InputStream)generatedInput, (Charset)StandardCharsets.UTF_8)) {
                        try {
                            Class<?> clazz = cl.loadClass(className);
                            TypedCqnServiceInvocationHandler.getCdsName(clazz).ifPresent(cdsName -> generatedServices.put((String)cdsName, (Class<? extends CqnService>)clazz));
                        }
                        catch (ClassNotFoundException e) {
                            logger.warn("Could not load generated service class '{}'", (Object)className);
                        }
                    }
                }
                finally {
                    if (generatedInput == null) continue;
                    generatedInput.close();
                }
            }
        }
        catch (IOException e) {
            logger.warn("Could not load list of generated service classes", (Throwable)e);
        }
    }
}

