/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.cds;

import com.sap.cds.ql.CdsName;
import com.sap.cds.ql.Select;
import com.sap.cds.ql.StructuredType;
import com.sap.cds.services.EventContext;
import com.sap.cds.services.Service;
import com.sap.cds.services.cds.CqnService;
import com.sap.cds.services.utils.StringUtils;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class TypedCqnServiceInvocationHandler
implements InvocationHandler {
    private final CqnService service;
    private final Map<Method, MethodInfo> methodInfos = new HashMap<Method, MethodInfo>();

    TypedCqnServiceInvocationHandler(CqnService service, Class<? extends CqnService> generatedInterface) {
        this.service = service;
        for (Method method : generatedInterface.getDeclaredMethods()) {
            String eventName = TypedCqnServiceInvocationHandler.getCdsName(method).orElse(method.getName());
            String entityName = null;
            Parameter[] parameters = method.getParameters();
            String[] argNames = new String[parameters.length];
            for (int i = 0; i < parameters.length; ++i) {
                Parameter parameter = parameters[i];
                if (i == 0 && StructuredType.class.isAssignableFrom(parameter.getType())) {
                    argNames[i] = "cqn";
                    entityName = TypedCqnServiceInvocationHandler.getCdsName(parameter.getType()).orElse(null);
                    continue;
                }
                argNames[i] = TypedCqnServiceInvocationHandler.getCdsName(parameter).orElse(parameter.getName());
            }
            this.methodInfos.put(method, new MethodInfo(eventName, entityName, argNames));
        }
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        MethodInfo methodInfo = this.methodInfos.get(method);
        if (methodInfo != null) {
            EventContext eventContext = TypedCqnServiceInvocationHandler.createEventContext(methodInfo, args);
            this.service.emit(eventContext);
            return eventContext.get("result");
        }
        try {
            return method.invoke((Object)this.service, args);
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
    }

    public Service getDelegatedService() {
        return this.service;
    }

    private static EventContext createEventContext(MethodInfo methodInfo, Object[] args) {
        EventContext eventContext = EventContext.create((String)methodInfo.event, (String)methodInfo.entity);
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                Object arg = args[i];
                if (i == 0 && arg instanceof StructuredType) {
                    StructuredType structuredType = (StructuredType)arg;
                    arg = Select.from((StructuredType)structuredType);
                }
                eventContext.put(methodInfo.argNames[i], arg);
            }
        }
        return eventContext;
    }

    static Optional<String> getCdsName(AnnotatedElement annotated) {
        CdsName cdsName = annotated.getAnnotation(CdsName.class);
        if (cdsName != null && !StringUtils.isEmpty((String)cdsName.value())) {
            return Optional.of(cdsName.value());
        }
        return Optional.empty();
    }

    private record MethodInfo(String event, String entity, String[] argNames) {
    }
}

