/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.draft;

import com.sap.cds.impl.util.Stack;
import com.sap.cds.ql.BooleanValue;
import com.sap.cds.ql.CQL;
import com.sap.cds.ql.RefBuilder;
import com.sap.cds.ql.cqn.CqnAnalyzer;
import com.sap.cds.ql.cqn.CqnArithmeticExpression;
import com.sap.cds.ql.cqn.CqnArithmeticNegation;
import com.sap.cds.ql.cqn.CqnComparisonPredicate;
import com.sap.cds.ql.cqn.CqnConnectivePredicate;
import com.sap.cds.ql.cqn.CqnContainmentTest;
import com.sap.cds.ql.cqn.CqnElementRef;
import com.sap.cds.ql.cqn.CqnExistsSubquery;
import com.sap.cds.ql.cqn.CqnExpand;
import com.sap.cds.ql.cqn.CqnExpression;
import com.sap.cds.ql.cqn.CqnFunc;
import com.sap.cds.ql.cqn.CqnInPredicate;
import com.sap.cds.ql.cqn.CqnInline;
import com.sap.cds.ql.cqn.CqnListValue;
import com.sap.cds.ql.cqn.CqnLiteral;
import com.sap.cds.ql.cqn.CqnMatchPredicate;
import com.sap.cds.ql.cqn.CqnNegation;
import com.sap.cds.ql.cqn.CqnNullValue;
import com.sap.cds.ql.cqn.CqnParameter;
import com.sap.cds.ql.cqn.CqnPlain;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.CqnReference;
import com.sap.cds.ql.cqn.CqnSearchPredicate;
import com.sap.cds.ql.cqn.CqnSelect;
import com.sap.cds.ql.cqn.CqnSelectListValue;
import com.sap.cds.ql.cqn.CqnSortSpecification;
import com.sap.cds.ql.cqn.CqnStructuredTypeRef;
import com.sap.cds.ql.cqn.CqnToken;
import com.sap.cds.ql.cqn.CqnValue;
import com.sap.cds.ql.cqn.CqnVisitor;
import com.sap.cds.ql.cqn.ResolvedSegment;
import com.sap.cds.ql.impl.Xpr;
import com.sap.cds.reflect.CdsAnnotatable;
import com.sap.cds.reflect.CdsAssociationType;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.services.draft.Drafts;
import com.sap.cds.services.utils.DraftUtils;
import com.sap.cds.util.CdsModelUtils;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class DraftScenarioAnalyzer {
    public static AnalysisResult analyze(CqnSelect select, CdsEntity target, CdsModel model) {
        if ((DraftUtils.isDraftEnabled((CdsAnnotatable)target) || target.getName().equals("DraftAdministrativeData")) && select.groupBy().isEmpty() && select.having().isEmpty() && select.from().isRef() && StatementAnalyzer.analyze(select, target).isOptimizable() && PredicateAnalyzer.analyze(select.search()).getComparison() == Comparison.OTHER) {
            CqnStructuredTypeRef ref = select.ref();
            RefAnalyzer refAnalyzer = RefAnalyzer.analyze(ref, model);
            PredicateAnalyzer whereAnalyzer = PredicateAnalyzer.analyze(select.where());
            Scenario scenario = DraftScenarioAnalyzer.mergeScenarios(refAnalyzer.getScenario(), whereAnalyzer.getScenario(), ref);
            return new AnalysisResult(scenario, whereAnalyzer.getPredicate(), refAnalyzer.getRemainingRef());
        }
        return new AnalysisResult(Scenario.NOT_OPTIMIZABLE, null, null);
    }

    private static Scenario mergeScenarios(Scenario refScenario, Scenario whereScenario, CqnStructuredTypeRef ref) {
        String lastSegment;
        Scenario scenario = refScenario == Scenario.OTHER ? whereScenario : (refScenario == Scenario.ALL_HIDING_DRAFTS && (whereScenario == Scenario.ALL_HIDING_DRAFTS || whereScenario == Scenario.OTHER) || refScenario == Scenario.OWN_DRAFT && (whereScenario == Scenario.OWN_DRAFT || whereScenario == Scenario.OTHER) ? ((lastSegment = ref.lastSegment()).equals("SiblingEntity") ? (refScenario == Scenario.OWN_DRAFT ? Scenario.ALL_HIDING_DRAFTS : Scenario.OWN_DRAFT) : (lastSegment.equals("DraftAdministrativeData") ? (refScenario == Scenario.OWN_DRAFT ? Scenario.OWN_DRAFT : Scenario.DRAFT_ADMINISTRATIVE_DATA_VIA_ACTIVE) : refScenario)) : Scenario.NOT_OPTIMIZABLE);
        return scenario;
    }

    private static boolean containsDraftElements(CqnElementRef ref) {
        return ref.segments().stream().map(CqnReference.Segment::id).anyMatch(Drafts.ELEMENTS::contains);
    }

    private static class StatementAnalyzer
    implements CqnVisitor {
        private final CdsEntity entity;
        private final Set<String> keyNames;
        private final boolean forExpand;
        private boolean optimizable = true;

        private static StatementAnalyzer analyze(CqnSelect select, CdsEntity target) {
            StatementAnalyzer validator = new StatementAnalyzer(target, false);
            select.accept((CqnVisitor)validator);
            return validator;
        }

        public StatementAnalyzer(CdsEntity entity, boolean forExpand) {
            this.entity = entity;
            this.keyNames = entity.keyElements().map(CdsElement::getName).collect(Collectors.toSet());
            this.forExpand = forExpand;
        }

        public boolean isOptimizable() {
            return this.optimizable;
        }

        public void visit(CqnStructuredTypeRef typeRef) {
            if (this.optimizable && (!this.forExpand && typeRef.segments().subList(0, typeRef.size() - 1).stream().anyMatch(s -> s.id().equals("SiblingEntity")) || this.forExpand && (typeRef.size() != 1 || typeRef.rootSegment().filter().isPresent() || typeRef.rootSegment().id().equals("SiblingEntity")))) {
                this.optimizable = false;
            }
        }

        public void visit(CqnSortSpecification sortSpec) {
            if (this.optimizable && sortSpec.value().ofRef().filter(r -> !r.path().equals("IsActiveEntity")).anyMatch(DraftScenarioAnalyzer::containsDraftElements)) {
                this.optimizable = false;
            }
        }

        public void visit(CqnSelectListValue slv) {
            if (this.optimizable) {
                CqnValue value = slv.value();
                String elementName = null;
                if (value.isRef()) {
                    CqnElementRef ref = value.asRef();
                    if (ref.size() > 1 && DraftScenarioAnalyzer.containsDraftElements(ref)) {
                        this.optimizable = false;
                    } else {
                        elementName = ref.path();
                    }
                } else if (value.isFunction()) {
                    if (value.asFunction().args().stream().flatMap(v -> v.ofRef()).anyMatch(DraftScenarioAnalyzer::containsDraftElements)) {
                        this.optimizable = false;
                    }
                } else if (this.refsOf((CqnToken)value).anyMatch(DraftScenarioAnalyzer::containsDraftElements)) {
                    this.optimizable = false;
                }
                if (this.optimizable && slv.alias().isPresent() && !((String)slv.alias().get()).equals(elementName) && (this.keyNames.contains(slv.alias().get()) || elementName != null && Drafts.ELEMENTS.contains(elementName))) {
                    this.optimizable = false;
                }
            }
        }

        public void visit(CqnExpand expand) {
            if (this.optimizable) {
                if (expand.ref().path().equals("*")) {
                    this.optimizable = false;
                } else {
                    StatementAnalyzer analyzer = new StatementAnalyzer(CdsModelUtils.entity((CdsEntity)this.entity, (List)expand.ref().segments()), true);
                    expand.ref().accept((CqnVisitor)analyzer);
                    expand.items().forEach(i -> i.accept((CqnVisitor)analyzer));
                    expand.orderBy().forEach(o -> o.accept((CqnVisitor)analyzer));
                    this.optimizable = analyzer.isOptimizable();
                }
            }
        }

        public void visit(CqnInline inline) {
            this.optimizable = false;
        }

        private Stream<CqnElementRef> refsOf(CqnToken token) {
            return token.tokens().filter(CqnElementRef.class::isInstance).map(CqnElementRef.class::cast);
        }
    }

    private static class PredicateAnalyzer
    implements CqnVisitor {
        private static final String IS_ACTIVE_ENTITY = "IsActiveEntity";
        private static final String SIBLING_ENTITY_IS_ACTIVE_ENTITY = "SiblingEntity.IsActiveEntity";
        private static final String HAS_DRAFT_ENTITY = "HasDraftEntity";
        private static final String DRAFT_ADMINISTRATIVE_DATA_IN_PROCESS_BY_USER = "DraftAdministrativeData.InProcessByUser";
        private final Stack<Object> scenarioStack = new Stack();
        private final Stack<CqnToken> predicateStack = new Stack();

        private PredicateAnalyzer() {
        }

        private static PredicateAnalyzer analyze(Optional<CqnPredicate> predicate) {
            PredicateAnalyzer analyzer = new PredicateAnalyzer();
            predicate.ifPresent(p -> p.accept((CqnVisitor)analyzer));
            return analyzer;
        }

        public Scenario getScenario() {
            Scenario s;
            Object comparison = this.getComparison();
            if (comparison == Comparison.IS_ACTIVE_ENTITY_EQ_TRUE) {
                comparison = Scenario.ALL_HIDING_DRAFTS;
            } else if (comparison == Comparison.IS_ACTIVE_ENTITY_EQ_FALSE) {
                comparison = Scenario.OWN_DRAFT;
            } else if (comparison == Comparison.OTHER) {
                comparison = Scenario.OTHER;
            }
            return comparison instanceof Scenario ? (s = (Scenario)((Object)comparison)) : Scenario.NOT_OPTIMIZABLE;
        }

        public CqnPredicate getPredicate() {
            BooleanValue booleanValue;
            BooleanValue token;
            Object object = token = this.predicateStack.size() == 1 ? (CqnToken)this.predicateStack.pop() : CQL.TRUE;
            if (token instanceof CqnPredicate) {
                CqnPredicate p = (CqnPredicate)token;
                booleanValue = p;
            } else {
                booleanValue = CQL.TRUE;
            }
            return booleanValue;
        }

        private Object getComparison() {
            return this.scenarioStack.size() == 1 ? this.scenarioStack.pop() : Comparison.OTHER;
        }

        public void visit(CqnComparisonPredicate c) {
            String ref;
            Object comparison = this.comparisonType(this.scenarioStack.pop(2));
            String string = c.left().isRef() ? c.left().asRef().path() : (ref = c.right().isRef() ? c.right().asRef().path() : null);
            if (ref != null) {
                Object value;
                boolean isNull;
                boolean bl = isNull = c.left().isNullValue() || c.right().isNullValue();
                Object object = c.left().isLiteral() ? c.left().asLiteral().value() : (value = c.right().isLiteral() ? c.right().asLiteral().value() : null);
                if (isNull || value != null) {
                    CqnComparisonPredicate.Operator op = c.operator();
                    if (ref.equals(IS_ACTIVE_ENTITY) && (op == CqnComparisonPredicate.Operator.IS || op == CqnComparisonPredicate.Operator.EQ)) {
                        if (Boolean.TRUE.equals(value)) {
                            comparison = Comparison.IS_ACTIVE_ENTITY_EQ_TRUE;
                        } else if (Boolean.FALSE.equals(value)) {
                            comparison = Comparison.IS_ACTIVE_ENTITY_EQ_FALSE;
                        }
                    } else if (ref.equals(SIBLING_ENTITY_IS_ACTIVE_ENTITY) && op == CqnComparisonPredicate.Operator.IS && isNull) {
                        comparison = Comparison.SIBLING_ENTITY_IS_ACTIVE_ENTITY_EQ_NULL;
                    } else if (ref.equals(HAS_DRAFT_ENTITY) && (op == CqnComparisonPredicate.Operator.IS || op == CqnComparisonPredicate.Operator.EQ) && Boolean.FALSE.equals(value)) {
                        comparison = Comparison.HAS_DRAFT_ENTITY_EQ_FALSE;
                    } else if (ref.equals(DRAFT_ADMINISTRATIVE_DATA_IN_PROCESS_BY_USER)) {
                        if ("".equals(value)) {
                            if (op == CqnComparisonPredicate.Operator.IS || op == CqnComparisonPredicate.Operator.EQ) {
                                comparison = Comparison.DRAFT_ADMINISTRATIVE_DATA_IN_PROCESS_BY_USER_EQ_EMPTY;
                            } else if (op == CqnComparisonPredicate.Operator.IS_NOT || op == CqnComparisonPredicate.Operator.NE) {
                                comparison = Comparison.DRAFT_ADMINISTRATIVE_DATA_IN_PROCESS_BY_USER_NE_EMPTY;
                            }
                        } else if (op == CqnComparisonPredicate.Operator.IS_NOT && isNull) {
                            comparison = Comparison.DRAFT_ADMINISTRATIVE_DATA_IN_PROCESS_BY_USER_NE_NULL;
                        }
                    }
                }
            }
            this.scenarioStack.push(comparison);
            this.predicateStack.pop(2);
            if (comparison == Comparison.OTHER || comparison == Comparison.DRAFT_RELATED) {
                this.predicateStack.push((Object)c);
            } else {
                this.predicateStack.push((Object)CQL.TRUE);
            }
        }

        public void visit(CqnConnectivePredicate connective) {
            HashSet<Object> comparisons = new HashSet<Object>(this.scenarioStack.pop(connective.predicates().size()));
            if (connective.operator() == CqnConnectivePredicate.Operator.AND) {
                comparisons.remove((Object)Comparison.OTHER);
            }
            if (comparisons.size() == 2 && connective.operator() == CqnConnectivePredicate.Operator.OR && comparisons.contains((Object)Comparison.IS_ACTIVE_ENTITY_EQ_FALSE) && comparisons.contains((Object)Comparison.SIBLING_ENTITY_IS_ACTIVE_ENTITY_EQ_NULL)) {
                this.scenarioStack.push((Object)Scenario.ALL);
            } else if (comparisons.size() == 2 && connective.operator() == CqnConnectivePredicate.Operator.AND && comparisons.contains((Object)Comparison.IS_ACTIVE_ENTITY_EQ_TRUE) && comparisons.contains((Object)Comparison.HAS_DRAFT_ENTITY_EQ_FALSE)) {
                this.scenarioStack.push((Object)Scenario.UNCHANGED);
            } else if (comparisons.size() == 3 && connective.operator() == CqnConnectivePredicate.Operator.AND && comparisons.contains((Object)Comparison.IS_ACTIVE_ENTITY_EQ_TRUE) && comparisons.contains((Object)Comparison.SIBLING_ENTITY_IS_ACTIVE_ENTITY_EQ_NULL) && comparisons.contains((Object)Comparison.DRAFT_ADMINISTRATIVE_DATA_IN_PROCESS_BY_USER_EQ_EMPTY)) {
                this.scenarioStack.push((Object)Scenario.UNSAVED_CHANGES_BY_ANOTHER_USER);
            } else if (comparisons.size() == 4 && connective.operator() == CqnConnectivePredicate.Operator.AND && comparisons.contains((Object)Comparison.IS_ACTIVE_ENTITY_EQ_TRUE) && comparisons.contains((Object)Comparison.SIBLING_ENTITY_IS_ACTIVE_ENTITY_EQ_NULL) && comparisons.contains((Object)Comparison.DRAFT_ADMINISTRATIVE_DATA_IN_PROCESS_BY_USER_NE_EMPTY) && comparisons.contains((Object)Comparison.DRAFT_ADMINISTRATIVE_DATA_IN_PROCESS_BY_USER_NE_NULL)) {
                this.scenarioStack.push((Object)Scenario.LOCKED_BY_ANOTHER_USER);
            } else if (comparisons.size() == 1 && connective.operator() == CqnConnectivePredicate.Operator.AND && (comparisons.iterator().next() instanceof Scenario || comparisons.contains((Object)Comparison.IS_ACTIVE_ENTITY_EQ_TRUE) || comparisons.contains((Object)Comparison.IS_ACTIVE_ENTITY_EQ_FALSE))) {
                this.scenarioStack.push(comparisons.iterator().next());
            } else {
                this.scenarioStack.push(this.comparisonType(comparisons));
            }
            List predicateTokens = this.predicateStack.pop(connective.predicates().size());
            this.predicateStack.push((Object)CQL.connect((CqnConnectivePredicate.Operator)connective.operator(), predicateTokens.stream().map(t -> (CqnPredicate)t).toList()));
        }

        public void visit(CqnElementRef elementRef) {
            if (DraftScenarioAnalyzer.containsDraftElements(elementRef)) {
                this.scenarioStack.push((Object)Comparison.DRAFT_RELATED);
            } else {
                this.scenarioStack.push((Object)Comparison.OTHER);
            }
            this.predicateStack.push((Object)elementRef);
        }

        public void visit(CqnPlain plain) {
            this.scenarioStack.push((Object)Comparison.DRAFT_RELATED);
            this.predicateStack.push((Object)plain);
        }

        public void visit(CqnParameter param) {
            this.pushOther((CqnToken)param);
        }

        public void visit(CqnLiteral<?> literal) {
            this.pushOther((CqnToken)literal);
        }

        public void visit(CqnNullValue nil) {
            this.pushOther((CqnToken)nil);
        }

        public void visit(CqnExistsSubquery exists) {
            this.pushOther((CqnToken)exists);
        }

        public void visit(CqnMatchPredicate match) {
            this.pushOther((CqnToken)match);
        }

        public void visit(CqnFunc func) {
            this.popPush(func.args().size(), (CqnToken)func);
        }

        public void visit(CqnListValue list) {
            this.popPush(list.size(), (CqnToken)list);
        }

        public void visit(CqnSearchPredicate search) {
            this.popPush(1, (CqnToken)search);
        }

        public void visit(CqnContainmentTest test) {
            this.popPush(2, (CqnToken)test);
        }

        public void visit(CqnInPredicate in) {
            this.popPush(2, (CqnToken)in);
        }

        public void visit(CqnArithmeticExpression expr) {
            this.popPush(2, (CqnToken)expr);
        }

        public void visit(CqnArithmeticNegation neg) {
            this.popPush(1, (CqnToken)neg);
        }

        public void visit(CqnNegation neg) {
            this.popPush(1, (CqnToken)neg);
        }

        public void visit(CqnExpression expr) {
            this.popPush(((Xpr)expr).length(), (CqnToken)expr);
        }

        private Object comparisonType(Collection<Object> comparisons) {
            return comparisons.stream().allMatch(Comparison.OTHER::equals) ? Comparison.OTHER : Comparison.DRAFT_RELATED;
        }

        private void pushOther(CqnToken token) {
            this.scenarioStack.push((Object)Comparison.OTHER);
            this.predicateStack.push((Object)token);
        }

        private void popPush(int pop, CqnToken token) {
            this.scenarioStack.push(this.comparisonType(this.scenarioStack.pop(pop)));
            this.predicateStack.pop(pop);
            this.predicateStack.push((Object)token);
        }
    }

    private static enum Comparison {
        IS_ACTIVE_ENTITY_EQ_TRUE,
        IS_ACTIVE_ENTITY_EQ_FALSE,
        SIBLING_ENTITY_IS_ACTIVE_ENTITY_EQ_NULL,
        HAS_DRAFT_ENTITY_EQ_FALSE,
        DRAFT_ADMINISTRATIVE_DATA_IN_PROCESS_BY_USER_EQ_EMPTY,
        DRAFT_ADMINISTRATIVE_DATA_IN_PROCESS_BY_USER_NE_EMPTY,
        DRAFT_ADMINISTRATIVE_DATA_IN_PROCESS_BY_USER_NE_NULL,
        DRAFT_RELATED,
        OTHER;

    }

    private static class RefAnalyzer {
        private final CdsModel model;
        private CqnStructuredTypeRef remainingRef;
        private Scenario scenario = Scenario.NOT_OPTIMIZABLE;

        public static RefAnalyzer analyze(CqnStructuredTypeRef ref, CdsModel model) {
            RefAnalyzer analyzer = new RefAnalyzer(ref, model);
            analyzer.analyze();
            return analyzer;
        }

        private RefAnalyzer(CqnStructuredTypeRef ref, CdsModel model) {
            this.model = model;
            this.remainingRef = ref;
        }

        public Scenario getScenario() {
            return this.scenario;
        }

        public CqnStructuredTypeRef getRemainingRef() {
            return this.remainingRef;
        }

        private void analyze() {
            RefBuilder ref = CQL.copy((CqnStructuredTypeRef)this.remainingRef);
            PredicateAnalyzer rootAnalyzer = PredicateAnalyzer.analyze(ref.rootSegment().filter());
            Scenario scenario = rootAnalyzer.getScenario();
            if (scenario == Scenario.ALL_HIDING_DRAFTS || scenario == Scenario.OWN_DRAFT) {
                ref.rootSegment().filter(rootAnalyzer.getPredicate());
                int endIndex = ref.segments().size();
                if (ref.targetSegment().id().equals("SiblingEntity")) {
                    ref.segments().remove(--endIndex);
                } else if (ref.targetSegment().id().equals("DraftAdministrativeData")) {
                    --endIndex;
                }
                Iterator iterator = CqnAnalyzer.create((CdsModel)this.model).analyze(this.remainingRef).iterator();
                for (int i = 1; i < endIndex; ++i) {
                    RefBuilder.RefSegment segment = (RefBuilder.RefSegment)ref.segments().get(i);
                    CdsEntity parentEntity = ((ResolvedSegment)iterator.next()).entity();
                    PredicateAnalyzer segmentAnalyzer = PredicateAnalyzer.analyze(segment.filter());
                    Scenario segmentScenario = segmentAnalyzer.getScenario();
                    boolean isComposition = parentEntity.findAssociation(segment.id()).map(a -> ((CdsAssociationType)a.getType().as(CdsAssociationType.class)).isComposition()).orElse(false);
                    if (!isComposition || segmentScenario != scenario && segmentScenario != Scenario.OTHER) {
                        return;
                    }
                    segment.filter(segmentAnalyzer.getPredicate());
                }
            }
            this.scenario = scenario;
            this.remainingRef = (CqnStructuredTypeRef)ref.build();
        }
    }

    public static enum Scenario {
        ALL,
        ALL_HIDING_DRAFTS,
        UNCHANGED,
        OWN_DRAFT,
        LOCKED_BY_ANOTHER_USER,
        UNSAVED_CHANGES_BY_ANOTHER_USER,
        DRAFT_ADMINISTRATIVE_DATA_VIA_ACTIVE,
        OTHER,
        NOT_OPTIMIZABLE;

    }

    public record AnalysisResult(Scenario scenario, CqnPredicate predicate, CqnStructuredTypeRef ref) {
    }
}

