/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.messaging.handlers;

import com.sap.cds.services.application.ApplicationPreparedEventContext;
import com.sap.cds.services.application.ApplicationStoppedEventContext;
import com.sap.cds.services.handler.EventHandler;
import com.sap.cds.services.handler.annotations.On;
import com.sap.cds.services.handler.annotations.ServiceName;
import com.sap.cds.services.messaging.service.AbstractMessagingService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ServiceName(value={"ApplicationLifecycleService$Default"})
public class MessagingInitilizationHandler
implements EventHandler {
    private static final Logger logger = LoggerFactory.getLogger(MessagingInitilizationHandler.class);

    @On
    protected void initializeMessaging(ApplicationPreparedEventContext context) {
        context.getServiceCatalog().getServices(AbstractMessagingService.class).forEach(service -> service.init());
        context.getCdsRuntime().getEnvironment().getCdsProperties().getMessaging().getServices().forEach((name, config) -> {
            if (config.isEnabled().booleanValue() && context.getServiceCatalog().getService(config.getName()) == null) {
                logger.warn("No messaging service was created for configuration with name '{}'", (Object)config.getName());
            }
        });
    }

    @On
    protected void stopMessaging(ApplicationStoppedEventContext context) {
        context.getServiceCatalog().getServices(AbstractMessagingService.class).forEach(service -> service.stop());
    }
}

