/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.outbox.persistence.collectors;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.sap.cds.services.impl.outbox.persistence.PersistentOutbox;
import com.sap.cds.services.impl.outbox.persistence.collectors.PartitionCollector;
import com.sap.cds.services.mt.TenantInfo;
import com.sap.cds.services.mt.TenantProviderService;
import com.sap.cds.services.outbox.OutboxService;
import com.sap.cds.services.runtime.CdsRuntime;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PartitionCollectorCoordinator {
    public static final int OUTBOX_MESSAGE_PARTITIONS = 2;
    private static final Logger LOG = LoggerFactory.getLogger(PartitionCollectorCoordinator.class);
    private final CdsRuntime runtime;
    private final int partitions = 2;
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(3, new ThreadFactoryBuilder().setDaemon(true).build());
    private final Map<Integer, PartitionCollector> collectors = new ConcurrentHashMap<Integer, PartitionCollector>();
    private final TenantProviderService tenantService;
    private volatile List<TenantInfo> tenantsInfo;

    public PartitionCollectorCoordinator(CdsRuntime runtime) {
        this.runtime = runtime;
        this.tenantService = (TenantProviderService)runtime.getServiceCatalog().getService(TenantProviderService.class, "TenantProviderService$Default");
        long tenantsInfoRefreshIntervalSeconds = runtime.getEnvironment().getCdsProperties().getOutbox().getPersistent().getTenantsInfoRefreshInterval().getSeconds();
        this.scheduler.scheduleAtFixedRate(this::updateTenants, 0L, tenantsInfoRefreshIntervalSeconds, TimeUnit.SECONDS);
    }

    private void updateTenants() {
        boolean initial = this.tenantsInfo == null;
        try {
            LOG.debug("Updating cached tenants for partition collectors");
            this.tenantsInfo = Collections.unmodifiableList(this.tenantService.readTenantsInfo());
            if (initial) {
                this.initCollectors();
            }
        }
        catch (Exception e) {
            LOG.warn("Failed to update cached tenants for partition collectors", (Throwable)e);
        }
    }

    private void initCollectors() {
        LOG.info("Initializing collectors for {} partitions", (Object)this.partitions);
        PersistentOutbox outboxService = (PersistentOutbox)this.runtime.getServiceCatalog().getService(OutboxService.class, "OutboxService$Persistent");
        for (int partition = 0; partition < this.partitions; ++partition) {
            PartitionCollector collector = new PartitionCollector(this.runtime, outboxService, () -> this.tenantsInfo, partition);
            this.collectors.put(partition, collector);
            this.scheduler.execute(collector);
        }
    }

    public void schedule(int partition) {
        PartitionCollector collector = this.collectors.get(partition);
        if (collector != null) {
            collector.unpause();
        }
    }

    public void stop() {
        this.scheduler.shutdownNow();
    }
}

