/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.persistence;

import com.sap.cds.CdsDataProcessor;
import com.sap.cds.reflect.CdsBaseType;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.services.EventContext;
import com.sap.cds.services.handler.EventHandler;
import com.sap.cds.services.handler.annotations.Before;
import com.sap.cds.services.handler.annotations.HandlerOrder;
import com.sap.cds.services.handler.annotations.ServiceName;
import com.sap.cds.services.impl.utils.CdsServiceUtils;
import com.sap.cds.services.persistence.PersistenceService;
import java.util.List;
import java.util.Map;
import java.util.UUID;

@ServiceName(value={"*"}, type={PersistenceService.class})
public class GenerateUUIDHandler
implements EventHandler {
    private static final CdsDataProcessor uuidKeyGenerator = CdsDataProcessor.create().addGenerator((p, element, type) -> element.isKey() && type.isSimpleType(CdsBaseType.UUID), (p, element, isNull) -> UUID.randomUUID().toString());

    @Before(event={"CREATE"})
    @HandlerOrder(value=11000)
    public void fillUUID(EventContext context) {
        List<Map<String, Object>> entries = CdsServiceUtils.getEntities(context);
        uuidKeyGenerator.process(entries, (CdsStructuredType)context.getTarget());
    }
}

