/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.services.impl;

import java.util.Set;

import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.services.EventContext;
import com.sap.cds.services.Service;
import com.sap.cds.services.ServiceCatalog;
import com.sap.cds.services.authentication.AuthenticationInfo;
import com.sap.cds.services.changeset.ChangeSetContext;
import com.sap.cds.services.messages.Messages;
import com.sap.cds.services.request.FeatureTogglesInfo;
import com.sap.cds.services.request.ParameterInfo;
import com.sap.cds.services.request.UserInfo;
import com.sap.cds.services.runtime.CdsRuntime;

public abstract class EventContextDelegator implements EventContext {

	private final EventContext eventContext;

	protected EventContextDelegator(EventContext eventContext) {
		this.eventContext = eventContext;
	}

	public EventContext getDelegatedEventContext() {
		return eventContext;
	}

	@Override
	public Service getService() {
		return eventContext.getService();
	}

	@Override
	public CdsRuntime getCdsRuntime() {
		return eventContext.getCdsRuntime();
	}

	@Override
	public CdsModel getModel() {
		return eventContext.getModel();
	}

	@Override
	public ServiceCatalog getServiceCatalog() {
		return eventContext.getServiceCatalog();
	}

	@Override
	public ParameterInfo getParameterInfo() {
		return eventContext.getParameterInfo();
	}

	@Override
	public UserInfo getUserInfo() {
		return eventContext.getUserInfo();
	}

	@Override
	public AuthenticationInfo getAuthenticationInfo() {
		return eventContext.getAuthenticationInfo();
	}

	@Override
	public FeatureTogglesInfo getFeatureTogglesInfo() {
		return eventContext.getFeatureTogglesInfo();
	}

	@Override
	public Messages getMessages() {
		return eventContext.getMessages();
	}

	@Override
	public ChangeSetContext getChangeSetContext() {
		return eventContext.getChangeSetContext();
	}

	@Override
	public String getEvent() {
		return eventContext.getEvent();
	}

	@Override
	public CdsEntity getTarget() {
		return eventContext.getTarget();
	}

	@Override
	@SuppressWarnings("unchecked")
	public <T extends EventContext> T as(Class<T> clazz) {
		if(clazz.isAssignableFrom(this.getClass())) {
			return (T) this;
		}
		return eventContext.as(clazz);
	}

	@Override
	public Object get(String key) {
		return eventContext.get(key);
	}

	@Override
	public void put(String key, Object value) {
		eventContext.put(key, value);
	}

	@Override
	public Set<String> keySet() {
		return eventContext.keySet();
	}

	@Override
	public void setCompleted() {
		eventContext.setCompleted();
	}

	@Override
	public boolean isCompleted() {
		return eventContext.isCompleted();
	}

}
