/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.services.impl;

import java.util.Locale;
import java.util.function.Function;

import com.sap.cds.ql.StructuredType;
import com.sap.cds.ql.cqn.Path;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.services.ServiceExceptionUtils;
import com.sap.cds.services.environment.CdsProperties.Errors;
import com.sap.cds.services.impl.messages.MessageTargetImpl;
import com.sap.cds.services.impl.messages.SimpleLocalizedMessageProvider;
import com.sap.cds.services.impl.request.RequestContextImpl;
import com.sap.cds.services.messages.LocalizedMessageProvider;
import com.sap.cds.services.messages.MessageTarget;
import com.sap.cds.services.request.RequestContext;

public class ServiceExceptionUtilsImpl implements ServiceExceptionUtils {

	public static LocalizedMessageProvider defaultLocalizedMessageProvider = new SimpleLocalizedMessageProvider();
	public static Errors errorsProperties = new Errors();

	@Override
	public String getMessage(String code, Object[] args) {
		return defaultLocalizedMessageProvider.get(code, args, null);
	}

	@Override
	public String getLocalizedMessage(String code, Object[] args, Locale locale) {
		Locale theLocale = locale;
		if (theLocale == null) {
			// try to resolve locale from request context (only works if one was explicitly opened)
			RequestContext requestContext = RequestContextImpl.getCurrentInternal();
			theLocale = requestContext != null ? requestContext.getParameterInfo().getLocale() : null;
		}
		return defaultLocalizedMessageProvider.get(code, args, theLocale);
	}

	@Override
	public MessageTarget getMessageTarget(String target) {
		return MessageTargetImpl.create(target);
	}

	@Override
	public MessageTarget getMessageTarget(String parameter, Function<StructuredType<?>, Object> path) {
		return MessageTargetImpl.create(parameter, path);
	}

	@Override
	public <E extends StructuredType<E>> MessageTarget getMessageTarget(String parameter, Class<E> type, Function<E, Object> path) {
		return MessageTargetImpl.create(parameter, type, path);
	}

	@Override
	public Errors getErrorsProperties() {
		return errorsProperties;
	}

	@Override
	public MessageTarget getMessageTarget(Path path, CdsElement element) {
		return MessageTargetImpl.create(path, element);
	}
}
