/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.services.impl.auditlog.events;

import com.sap.cds.Struct;
import com.sap.cds.ql.CdsName;
import com.sap.cds.services.runtime.CdsRuntime;

@CdsName("com.sap.auditlog.events.TenantOnboarded")
public interface TenantOnboardedEvent extends AuditEvent {

	Event getEvent();

	void setEvent(Event event);

	TenantEventData getData();

	void setData(TenantEventData data);

	static TenantOnboardedEvent create(String tenantId, CdsRuntime runtime) {
		TenantOnboardedEvent onboarded = Struct.access(AuditEvent.create(runtime))
				.as(TenantOnboardedEvent.class);

		TenantEventData data = TenantEventData.create();
		data.setMessageId("TENANT_ONBOARDING");
		data.setMessage("Tenant has been onboarded.");
		data.setTenantId(tenantId);
		onboarded.setData(data);
		return onboarded;
	}
}
