/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.services.impl.cds;

import com.sap.cds.services.EventContext;
import com.sap.cds.services.cds.ApplicationService;
import com.sap.cds.services.handler.EventHandler;
import com.sap.cds.services.handler.annotations.Before;
import com.sap.cds.services.handler.annotations.HandlerOrder;
import com.sap.cds.services.handler.annotations.ServiceName;
import com.sap.cds.services.utils.OrderConstants;

@ServiceName(value = "*", type = {ApplicationService.class})
public class ValidationErrorHandler implements EventHandler {
	
	@Before
	@HandlerOrder(OrderConstants.Before.THROW_IF_ERROR)
	public void throwIfError(EventContext context) {
		if (context.getCdsRuntime().getEnvironment().getCdsProperties().getErrors().isCombined()) {
			context.getMessages().throwIfError();
		}
	}

}
