/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.services.impl.environment;

import com.sap.cds.services.environment.ApplicationInfo;
import com.sap.cds.services.environment.ApplicationInfoProvider;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.utils.environment.VcapApplicationParser;

public class DefaultApplicationInfoProvider implements ApplicationInfoProvider {

	private ApplicationInfo properties;
	private final CdsRuntime runtime;

	public DefaultApplicationInfoProvider(CdsRuntime runtime) {
		this.runtime = runtime;
	}

	@Override
	public ApplicationInfo get() {
		if(properties == null) {
			String configuredPath = runtime.getEnvironment().getCdsProperties().getEnvironment().getLocal().getDefaultEnvPath();
			properties = VcapApplicationParser.getApplicationInfo(DefaultEnvFileUtils.getDefaultEnv(configuredPath));
		}
		return properties;
	}

}
