/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.services.impl.utils;

import java.util.ArrayList;
import java.util.List;

import com.sap.cds.services.EventContext;
import com.sap.cds.services.impl.ContextualizedServiceException;

public class DeveloperModeUtils {

	private DeveloperModeUtils() {
		// empty
	}

	public static void extendMessage(StringBuilder builder, ContextualizedServiceException contextualizedException) {
		EventContext errorContext = contextualizedException.getErrorContext();
		builder.append("\n\tParameters from context:");
		for (String key : errorContext.keySet()) {
			builder.append("\n\t").append(key).append(" = '").append(errorContext.get(key).toString()).append("'");
		}

		// iterate service hierarchy from exception stack and through via list
		Throwable exception = contextualizedException;
		while (exception != null) {
			if (exception instanceof ContextualizedServiceException) {
				ContextualizedServiceException contextualized = (ContextualizedServiceException) exception;

				List<EventContext> viaList = new ArrayList<>();
				// add also the error context to the via list from exceptions further down the call stack
				if (!contextualized.equals(contextualizedException)) {
					viaList.add(contextualized.getErrorContext());
				}
				viaList.addAll(contextualized.getViaList());

				for (EventContext via : viaList) {
					builder.append("\n\tvia service '").append(via.getService().getName()).append("', ");
					builder.append("event '").append(via.getEvent()).append("', ");
					if (via.getTarget() != null) {
						builder.append("entity '").append(via.getTarget().getQualifiedName()).append("'");
					}
				}
			}
			exception = exception.getCause();
		}
	}

}
