/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.services.impl.utils;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import com.sap.cds.ql.CQL;
import com.sap.cds.ql.cqn.CqnAnalyzer;
import com.sap.cds.ql.cqn.CqnReference.Segment;
import com.sap.cds.ql.cqn.CqnStructuredTypeRef;
import com.sap.cds.ql.cqn.ResolvedSegment;
import com.sap.cds.reflect.CdsEntity;

public abstract class PathAwareCqnModifier extends TargetAwareCqnModifier {

	protected final CqnAnalyzer analyzer;

	public PathAwareCqnModifier(CqnAnalyzer analyzer, CdsEntity target) {
		super(target);
		this.analyzer = analyzer;
	}

	@Override
	public CqnStructuredTypeRef ref(CqnStructuredTypeRef ref) {
		Iterator<ResolvedSegment> resolved = analyzer.analyze(ref).iterator();
		List<Segment> segments = new ArrayList<>(ref.size());
		for (int i = 0; resolved.hasNext(); ++i) {
			Segment segment = ref.segments().get(i);
			segments.add(segment(segment, resolved.next(), i, ref));
		}

		return CQL.to(segments).asRef();
	}

	protected abstract Segment segment(Segment segment, ResolvedSegment resolved, int position, CqnStructuredTypeRef ref);

}
