/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.outbox;

import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.Service;
import com.sap.cds.services.impl.outbox.OutboxedServiceInvocationHandler;
import com.sap.cds.services.outbox.OutboxService;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.LinkedHashSet;

public class OutboxedServiceProxyUtils {
    private OutboxedServiceProxyUtils() {
    }

    public static <S extends Service> S unboxed(S service) {
        InvocationHandler invocationHandler;
        if (Proxy.isProxyClass(service.getClass()) && (invocationHandler = Proxy.getInvocationHandler(service)) instanceof OutboxedServiceInvocationHandler) {
            OutboxedServiceInvocationHandler serviceInvocationHandler = (OutboxedServiceInvocationHandler)invocationHandler;
            return (S)serviceInvocationHandler.getDelegatedService();
        }
        return service;
    }

    public static <S extends Service> S outboxed(OutboxService outboxService, S service, CdsRuntime runtime) {
        InvocationHandler invocationHandler;
        OutboxedServiceProxyUtils.ensureNotOutboxService(service);
        Object serviceForOutboxing = service;
        if (Proxy.isProxyClass(service.getClass()) && (invocationHandler = Proxy.getInvocationHandler(service)) instanceof OutboxedServiceInvocationHandler) {
            OutboxedServiceInvocationHandler serviceInvocationHandler = (OutboxedServiceInvocationHandler)invocationHandler;
            if (serviceInvocationHandler.getOutboxService() == outboxService) {
                return service;
            }
            serviceForOutboxing = serviceInvocationHandler.getDelegatedService();
        }
        invocationHandler = new OutboxedServiceInvocationHandler(outboxService, (Service)serviceForOutboxing, runtime);
        return (S)((Service)Proxy.newProxyInstance(service.getClass().getClassLoader(), OutboxedServiceProxyUtils.getInterfaces(service), invocationHandler));
    }

    private static <S extends Service> void ensureNotOutboxService(S service) {
        if (service instanceof OutboxService) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.OUTBOX_SERVICE_NOT_OUTBOXABLE, new Object[]{service.getName()});
        }
    }

    private static Class<?>[] getInterfaces(Service service) {
        LinkedHashSet interfaces = new LinkedHashSet();
        Class<?> clazz = service.getClass();
        do {
            LinkedHashSet nextInterfaces = new LinkedHashSet(Arrays.asList(clazz.getInterfaces()));
            if (interfaces.size() == 1) {
                boolean allAssignable = true;
                Class current = (Class)interfaces.iterator().next();
                for (Class clazz2 : nextInterfaces) {
                    if (clazz2.isAssignableFrom(current)) continue;
                    allAssignable = false;
                    break;
                }
                if (allAssignable) continue;
                interfaces.addAll(nextInterfaces);
                continue;
            }
            interfaces.addAll(nextInterfaces);
        } while ((clazz = clazz.getSuperclass()) != null);
        return interfaces.toArray(new Class[0]);
    }
}

