/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.utils;

import com.sap.cds.Result;
import com.sap.cds.SessionContext;
import com.sap.cds.ql.cqn.CqnInsert;
import com.sap.cds.ql.cqn.CqnUpdate;
import com.sap.cds.ql.cqn.CqnUpsert;
import com.sap.cds.ql.cqn.CqnXsert;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.EventContext;
import com.sap.cds.services.Service;
import com.sap.cds.services.ServiceDelegator;
import com.sap.cds.services.cds.CdsCreateEventContext;
import com.sap.cds.services.cds.CdsDeleteEventContext;
import com.sap.cds.services.cds.CdsReadEventContext;
import com.sap.cds.services.cds.CdsUpdateEventContext;
import com.sap.cds.services.cds.CdsUpsertEventContext;
import com.sap.cds.services.impl.EventContextDelegator;
import com.sap.cds.services.impl.EventContextSPI;
import com.sap.cds.services.impl.ServiceSPI;
import com.sap.cds.services.impl.cds.TypedCqnServiceInvocationHandler;
import com.sap.cds.services.impl.outbox.OutboxedServiceInvocationHandler;
import com.sap.cds.services.persistence.PersistenceService;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import com.sap.cds.services.utils.SessionContextUtils;
import com.sap.cds.util.PathExpressionResolver;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.List;
import java.util.Map;

public class CdsServiceUtils {
    public static PersistenceService getDefaultPersistenceService(EventContext context) {
        return (PersistenceService)context.getServiceCatalog().getService(PersistenceService.class, "PersistenceService$Default");
    }

    public static ServiceSPI getServiceSPI(Service service) {
        InvocationHandler invocationHandler;
        if (service instanceof ServiceSPI) {
            return (ServiceSPI)service;
        }
        if (service instanceof ServiceDelegator) {
            ServiceDelegator delegator = (ServiceDelegator)service;
            return CdsServiceUtils.getServiceSPI(delegator.getDelegatedService());
        }
        if (service != null && Proxy.isProxyClass(service.getClass()) && (invocationHandler = Proxy.getInvocationHandler(service)) instanceof TypedCqnServiceInvocationHandler) {
            TypedCqnServiceInvocationHandler proxyHandler = (TypedCqnServiceInvocationHandler)invocationHandler;
            return CdsServiceUtils.getServiceSPI(proxyHandler.getDelegatedService());
        }
        if (service != null && Proxy.isProxyClass(service.getClass()) && (invocationHandler = Proxy.getInvocationHandler(service)) instanceof OutboxedServiceInvocationHandler) {
            OutboxedServiceInvocationHandler proxyHandler = (OutboxedServiceInvocationHandler)invocationHandler;
            return CdsServiceUtils.getServiceSPI(proxyHandler.getDelegatedService());
        }
        return null;
    }

    public static Class<?> getServiceType(Service service) {
        Class<?>[] interfaces;
        Class<?> clazz = service.getClass();
        if (Proxy.isProxyClass(clazz) && (interfaces = clazz.getInterfaces()).length == 1) {
            return interfaces[0];
        }
        return clazz;
    }

    public static List<Map<String, Object>> getEntities(EventContext context) {
        switch (context.getEvent()) {
            case "CREATE": {
                return ((CdsCreateEventContext)context.as(CdsCreateEventContext.class)).getCqn().entries();
            }
            case "UPDATE": {
                return ((CdsUpdateEventContext)context.as(CdsUpdateEventContext.class)).getCqn().entries();
            }
            case "UPSERT": {
                return ((CdsUpsertEventContext)context.as(CdsUpsertEventContext.class)).getCqn().entries();
            }
        }
        throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.UNEXPECTED_EVENT, new Object[]{context.getEvent()});
    }

    public static List<Map<String, Object>> getEntitiesResolved(EventContext context) {
        switch (context.getEvent()) {
            case "CREATE": {
                return ((CqnInsert)PathExpressionResolver.resolvePath((CdsModel)context.getModel(), (CqnXsert)((CdsCreateEventContext)context.as(CdsCreateEventContext.class)).getCqn(), (SessionContext)SessionContextUtils.toSessionContext((EventContext)context))).entries();
            }
            case "UPDATE": {
                return PathExpressionResolver.resolvePath((CdsModel)context.getModel(), (CqnUpdate)((CdsUpdateEventContext)context.as(CdsUpdateEventContext.class)).getCqn()).entries();
            }
            case "UPSERT": {
                return ((CqnUpsert)PathExpressionResolver.resolvePath((CdsModel)context.getModel(), (CqnXsert)((CdsUpsertEventContext)context.as(CdsUpsertEventContext.class)).getCqn(), (SessionContext)SessionContextUtils.toSessionContext((EventContext)context))).entries();
            }
        }
        throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.UNEXPECTED_EVENT, new Object[]{context.getEvent()});
    }

    public static Result getResult(EventContext context) {
        switch (context.getEvent()) {
            case "READ": {
                return ((CdsReadEventContext)context.as(CdsReadEventContext.class)).getResult();
            }
            case "CREATE": {
                return ((CdsCreateEventContext)context.as(CdsCreateEventContext.class)).getResult();
            }
            case "UPDATE": {
                return ((CdsUpdateEventContext)context.as(CdsUpdateEventContext.class)).getResult();
            }
            case "UPSERT": {
                return ((CdsUpsertEventContext)context.as(CdsUpsertEventContext.class)).getResult();
            }
            case "DELETE": {
                return ((CdsDeleteEventContext)context.as(CdsDeleteEventContext.class)).getResult();
            }
        }
        throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.UNEXPECTED_EVENT, new Object[]{context.getEvent()});
    }

    public static EventContextSPI getEventContextSPI(EventContext eventContext) {
        if (eventContext instanceof EventContextSPI) {
            return (EventContextSPI)eventContext;
        }
        if (eventContext instanceof EventContextDelegator) {
            return CdsServiceUtils.getEventContextSPI(((EventContextDelegator)eventContext).getDelegatedEventContext());
        }
        return null;
    }
}

