/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.services.impl;

import com.sap.cds.services.Service;
import com.sap.cds.services.handler.Handler;

/**
 * Functional interface to filter for certain events and entities, when registering {@link Handler} instances on {@link Service} instances.
 */
@FunctionalInterface
public interface EventPredicate {

	/**
	 * {@link EventPredicate}, which always evaluates to true
	 */
	public static final EventPredicate ALL = (String event, String entity) -> true;

	/**
	 * Returns true, if a given event and entity should be handled by the {@link Handler} registered with this {@link EventPredicate}
	 * @param event the event
	 * @param entity the entity
	 * @return true, if the given event and entity should be handled, false otherwise
	 */
	public boolean test(String event, String entity);
}
