/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.services.impl.auditlog;

import com.sap.cds.services.auditlog.AuditLogService;
import com.sap.cds.services.cds.ApplicationService;
import com.sap.cds.services.environment.CdsProperties.AuditLog;
import com.sap.cds.services.outbox.OutboxService;
import com.sap.cds.services.persistence.PersistenceService;
import com.sap.cds.services.runtime.CdsRuntimeConfiguration;
import com.sap.cds.services.runtime.CdsRuntimeConfigurer;
import com.sap.cds.services.utils.outbox.OutboxUtils;

public class AuditLogServiceConfiguration implements CdsRuntimeConfiguration {

	@Override
	@SuppressWarnings("deprecation")
	public void services(CdsRuntimeConfigurer configurer) {
		AuditLogService auditLogService = new AuditLogServiceImpl(AuditLogService.DEFAULT_NAME, configurer.getCdsRuntime());

		AuditLog.Outbox outboxConfig = configurer.getCdsRuntime().getEnvironment().getCdsProperties().getAuditLog().getOutbox();
		if (outboxConfig.isEnabled()) {
			String outboxName = outboxConfig.getPersistent().isEnabled() ? outboxConfig.getName() : OutboxService.INMEMORY_NAME;
			auditLogService = OutboxUtils.outboxed(auditLogService, outboxName, configurer.getCdsRuntime());
		}

		configurer.service(auditLogService);
	}

	@Override
	public void eventHandlers(CdsRuntimeConfigurer configurer) {
		configurer.eventHandler(new AuditLogDefaultOnHandler());
		configurer.eventHandler(new AuditLogOutboxHandler());

		if (configurer.getCdsRuntime().getEnvironment().getCdsProperties().getAuditLog().getPersonalData().isEnabled()) { // NOSONAR
			PersonalDataCaches caches = new PersonalDataCaches(configurer.getCdsRuntime());
			if(configurer.getCdsRuntime().getServiceCatalog().getServices(ApplicationService.class).findAny().isPresent()) {
				configurer.eventHandler(new ApplicationServicePersonalDataHandler(caches, configurer.getCdsRuntime()));
			}
			if(configurer.getCdsRuntime().getServiceCatalog().getServices(PersistenceService.class).findAny().isPresent()) {
				configurer.eventHandler(new PersistenceServicePersonalDataHandler(caches, configurer.getCdsRuntime()));
			}
		}
	}
}
