/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.services.impl.outbox;

import com.sap.cds.CdsData;
import com.sap.cds.Struct;
import com.sap.cds.ql.CdsName;
import com.sap.cds.services.utils.outbox.OutboxUtils;

import java.time.Instant;

@CdsName(OutboxUtils.OUTBOX_MODEL)
public interface Messages extends CdsData {
  String ID = "ID";

  String TIMESTAMP = "timestamp";

  String TARGET = "target";

  String MSG = "msg";

  String ATTEMPTS = "attempts";

  String PARTITION = "partition";

  String LAST_ERROR = "lastError";

  String LAST_ATTEMPT_TIMESTAMP = "lastAttemptTimestamp";

  @CdsName(ID)
  String getId();

  @CdsName(ID)
  void setId(String id);

  Instant getTimestamp();

  void setTimestamp(Instant timestamp);

  String getTarget();

  void setTarget(String target);

  String getMsg();

  void setMsg(String msg);

  Integer getAttempts();

  void setAttempts(Integer attempts);

  Integer getPartition();

  void setPartition(Integer partition);

  String getLastError();

  void setLastError(String lastError);

  Instant getLastAttemptTimestamp();

  void setLastAttemptTimestamp(Instant lastAttemptTimestamp);

  Messages_ ref();

  static Messages create() {
    return Struct.create(Messages.class);
  }
}
