/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.services.impl.outbox.persistence;

import com.sap.cds.services.application.ApplicationLifecycleService;
import com.sap.cds.services.application.ApplicationPreparedEventContext;
import com.sap.cds.services.application.ApplicationStoppedEventContext;
import com.sap.cds.services.handler.EventHandler;
import com.sap.cds.services.handler.annotations.After;
import com.sap.cds.services.handler.annotations.On;
import com.sap.cds.services.handler.annotations.ServiceName;
import com.sap.cds.services.impl.outbox.persistence.collectors.TenantCache;

@ServiceName(ApplicationLifecycleService.DEFAULT_NAME)
public class PersistentOutboxInitializationHandler implements EventHandler {

	private final TenantCache tenantCache;

	public PersistentOutboxInitializationHandler(TenantCache tenantCache) {
		this.tenantCache = tenantCache;
	}

	@After
	protected void initOutboxCollectors(ApplicationPreparedEventContext context) {
		if (context.getCdsRuntime().getEnvironment().getCdsProperties().getEnvironment().getCommand().isEnabled()) {
			return;
		}

		tenantCache.start(context.getCdsRuntime());
		context.getCdsRuntime().getServiceCatalog().getServices(PersistentOutbox.class).forEach(PersistentOutbox::init);
	}

	@On
	protected void stopOutboxCollectors(ApplicationStoppedEventContext context) {
		context.getCdsRuntime().getServiceCatalog().getServices(PersistentOutbox.class).forEach(PersistentOutbox::stop);
		tenantCache.stop();
	}

}
