/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.cds;

import com.sap.cds.ql.CQL;
import com.sap.cds.ql.cqn.CqnDelete;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.CqnSelect;
import com.sap.cds.ql.cqn.CqnStatement;
import com.sap.cds.ql.cqn.CqnUpdate;
import com.sap.cds.reflect.CdsAnnotatable;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.EventContext;
import com.sap.cds.services.authorization.AuthorizationService;
import com.sap.cds.services.cds.ApplicationService;
import com.sap.cds.services.cds.CdsDeleteEventContext;
import com.sap.cds.services.cds.CdsReadEventContext;
import com.sap.cds.services.cds.CdsUpdateEventContext;
import com.sap.cds.services.draft.DraftEditEventContext;
import com.sap.cds.services.draft.DraftSaveEventContext;
import com.sap.cds.services.handler.EventHandler;
import com.sap.cds.services.handler.annotations.Before;
import com.sap.cds.services.handler.annotations.HandlerOrder;
import com.sap.cds.services.handler.annotations.ServiceName;
import com.sap.cds.services.impl.utils.CdsModelUtils;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.DraftUtils;
import com.sap.cds.services.utils.ErrorStatusException;
import com.sap.cds.services.utils.model.CqnUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ServiceName(value={"*"}, type={ApplicationService.class})
public class AuthorizationHandler
implements EventHandler {
    private static final Logger logger = LoggerFactory.getLogger(AuthorizationHandler.class);

    @Before(event={"*"})
    @HandlerOrder(value=-10900)
    private void checkAuthorization(EventContext context) {
        if (!context.getUserInfo().isPrivileged()) {
            this.authorizeOrThrow(context);
        }
    }

    private void authorizeOrThrow(EventContext context) {
        String actionOrFuntionName;
        AuthorizationService authService = (AuthorizationService)context.getServiceCatalog().getService(AuthorizationService.class, "AuthorizationService$Default");
        String event = context.getEvent();
        String serviceName = ((ApplicationService)context.getService()).getDefinition().getQualifiedName();
        if (!authService.hasServiceAccess(serviceName, event)) {
            AuthorizationHandler.throwOnAuthorizationError(context, event, serviceName);
        }
        CdsEntity targetEntity = context.getTarget();
        String entityName = null;
        if (targetEntity != null) {
            entityName = targetEntity.getQualifiedName();
            CqnStatement query = null;
            Object cqn = context.get("cqn");
            if (cqn instanceof CqnStatement) {
                CqnStatement statement;
                query = statement = (CqnStatement)cqn;
            }
            if (!authService.hasEntityAccess(entityName, event, query)) {
                AuthorizationHandler.throwOnAuthorizationError(context, event, entityName);
            }
        }
        String string = actionOrFuntionName = targetEntity == null ? serviceName + "." + event : event;
        if (!CdsModelUtils.isStandardCdsEvent(event)) {
            if (CdsModelUtils.getAction(context.getModel(), entityName, actionOrFuntionName).isPresent() && !authService.hasActionAccess(entityName, actionOrFuntionName)) {
                AuthorizationHandler.throwOnAuthorizationError(context, actionOrFuntionName, entityName != null ? entityName : serviceName);
            } else if (CdsModelUtils.getFunction(context.getModel(), entityName, actionOrFuntionName).isPresent() && !authService.hasFunctionAccess(entityName, actionOrFuntionName)) {
                AuthorizationHandler.throwOnAuthorizationError(context, actionOrFuntionName, entityName != null ? entityName : serviceName);
            }
        }
        if (event.equals("READ") || event.equals("DELETE") || event.equals("UPDATE") || event.equals("draftEdit") || event.equals("draftActivate")) {
            CqnPredicate wherePred = authService.calcWhereCondition(entityName, event);
            if (wherePred != null) {
                if (context.getEvent().equals("READ")) {
                    CdsReadEventContext cdsContext = (CdsReadEventContext)context.as(CdsReadEventContext.class);
                    if (targetEntity != null && DraftUtils.isDraftEnabled((CdsAnnotatable)targetEntity)) {
                        wherePred = CQL.or((CqnPredicate)wherePred, (CqnPredicate)CQL.get((String)"IsActiveEntity").eq((Object)false));
                    }
                    CqnSelect cqn = (CqnSelect)CqnUtils.addWhere((CqnStatement)cdsContext.getCqn(), (CqnPredicate)wherePred);
                    cdsContext.setCqn(cqn);
                } else if (context.getEvent().equals("DELETE")) {
                    CdsDeleteEventContext deleteContext = (CdsDeleteEventContext)context.as(CdsDeleteEventContext.class);
                    if (targetEntity != null && DraftUtils.isDraftEnabled((CdsAnnotatable)targetEntity)) {
                        wherePred = CQL.or((CqnPredicate)wherePred, (CqnPredicate)CQL.get((String)"IsActiveEntity").eq((Object)false));
                    }
                    CqnDelete cqn = (CqnDelete)CqnUtils.addWhere((CqnStatement)deleteContext.getCqn(), (CqnPredicate)wherePred);
                    deleteContext.setCqn(cqn);
                } else if (context.getEvent().equals("UPDATE")) {
                    CdsUpdateEventContext updateContext = (CdsUpdateEventContext)context.as(CdsUpdateEventContext.class);
                    if (targetEntity != null && DraftUtils.isDraftEnabled((CdsAnnotatable)targetEntity)) {
                        wherePred = CQL.or((CqnPredicate)wherePred, (CqnPredicate)CQL.get((String)"IsActiveEntity").eq((Object)false));
                    }
                    CqnUpdate cqn = (CqnUpdate)CqnUtils.addWhere((CqnStatement)updateContext.getCqn(), (CqnPredicate)wherePred);
                    updateContext.setCqn(cqn);
                } else if (event.equals("draftEdit")) {
                    DraftEditEventContext draftEditContext = (DraftEditEventContext)context.as(DraftEditEventContext.class);
                    CqnSelect cqn = (CqnSelect)CqnUtils.addWhere((CqnStatement)draftEditContext.getCqn(), (CqnPredicate)wherePred);
                    draftEditContext.setCqn(cqn);
                } else if (event.equals("draftActivate")) {
                    DraftSaveEventContext saveContext = (DraftSaveEventContext)context.as(DraftSaveEventContext.class);
                    CqnSelect cqn = (CqnSelect)CqnUtils.addWhere((CqnStatement)saveContext.getCqn(), (CqnPredicate)wherePred);
                    saveContext.setCqn(cqn);
                }
                logger.debug("Created CQN authorization predicate {} for entity '{}' of service '{}', event {} and user {}", new Object[]{wherePred.toJson(), entityName, serviceName, event, context.getUserInfo().getName()});
            } else {
                logger.debug("No CQN authorization predicate required for entity '{}' of service '{}', event {} and user {}", new Object[]{entityName, serviceName, event, context.getUserInfo().getName()});
            }
        }
    }

    private static void throwOnAuthorizationError(EventContext context, String event, String cdsElement) {
        if (context.getUserInfo().isAuthenticated()) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.EVENT_FORBIDDEN, new Object[]{event, cdsElement});
        }
        throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.EVENT_UNAUTHENTICATED, new Object[]{event, cdsElement});
    }
}

