/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl;

import com.sap.cds.Struct;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.EventContext;
import com.sap.cds.services.EventName;
import com.sap.cds.services.Service;
import com.sap.cds.services.ServiceCatalog;
import com.sap.cds.services.auditlog.ConfigChangeLogContext;
import com.sap.cds.services.auditlog.DataAccessLogContext;
import com.sap.cds.services.auditlog.DataModificationLogContext;
import com.sap.cds.services.auditlog.SecurityLogContext;
import com.sap.cds.services.authentication.AuthenticationInfo;
import com.sap.cds.services.authorization.CalcWhereConditionEventContext;
import com.sap.cds.services.authorization.EntityAccessEventContext;
import com.sap.cds.services.authorization.FunctionAccessEventContext;
import com.sap.cds.services.authorization.GetRestrictionEventContext;
import com.sap.cds.services.authorization.ServiceAccessEventContext;
import com.sap.cds.services.cds.CdsCreateEventContext;
import com.sap.cds.services.cds.CdsDeleteEventContext;
import com.sap.cds.services.cds.CdsReadEventContext;
import com.sap.cds.services.cds.CdsUpdateEventContext;
import com.sap.cds.services.cds.CdsUpsertEventContext;
import com.sap.cds.services.changeset.ChangeSetContext;
import com.sap.cds.services.draft.ActiveReadEventContext;
import com.sap.cds.services.draft.DraftCancelEventContext;
import com.sap.cds.services.draft.DraftCreateEventContext;
import com.sap.cds.services.draft.DraftEditEventContext;
import com.sap.cds.services.draft.DraftGcEventContext;
import com.sap.cds.services.draft.DraftNewEventContext;
import com.sap.cds.services.draft.DraftPatchEventContext;
import com.sap.cds.services.draft.DraftPrepareEventContext;
import com.sap.cds.services.draft.DraftReadEventContext;
import com.sap.cds.services.draft.DraftSaveEventContext;
import com.sap.cds.services.impl.EventContextSPI;
import com.sap.cds.services.impl.ServiceSPI;
import com.sap.cds.services.impl.auditlog.ConfigChangeLogContextImpl;
import com.sap.cds.services.impl.auditlog.DataAccessLogContextImpl;
import com.sap.cds.services.impl.auditlog.DataModificationLogContextImpl;
import com.sap.cds.services.impl.auditlog.SecurityLogContextImpl;
import com.sap.cds.services.impl.authorization.CalcWhereConditionEventContextImpl;
import com.sap.cds.services.impl.authorization.EntityAccessEventContextImpl;
import com.sap.cds.services.impl.authorization.FunctionAccessEventContextImpl;
import com.sap.cds.services.impl.authorization.GetRestrictionEventContextImpl;
import com.sap.cds.services.impl.authorization.ServiceAccessEventContextImpl;
import com.sap.cds.services.impl.cds.CdsCreateEventContextImpl;
import com.sap.cds.services.impl.cds.CdsDeleteEventContextImpl;
import com.sap.cds.services.impl.cds.CdsReadEventContextImpl;
import com.sap.cds.services.impl.cds.CdsUpdateEventContextImpl;
import com.sap.cds.services.impl.cds.CdsUpsertEventContextImpl;
import com.sap.cds.services.impl.draft.ActiveReadEventContextImpl;
import com.sap.cds.services.impl.draft.DraftCancelEventContextImpl;
import com.sap.cds.services.impl.draft.DraftCreateEventContextImpl;
import com.sap.cds.services.impl.draft.DraftEditEventContextImpl;
import com.sap.cds.services.impl.draft.DraftGcEventContextImpl;
import com.sap.cds.services.impl.draft.DraftNewEventContextImpl;
import com.sap.cds.services.impl.draft.DraftPatchEventContextImpl;
import com.sap.cds.services.impl.draft.DraftPrepareEventContextImpl;
import com.sap.cds.services.impl.draft.DraftReadEventContextImpl;
import com.sap.cds.services.impl.draft.DraftSaveEventContextImpl;
import com.sap.cds.services.impl.request.RequestContextImpl;
import com.sap.cds.services.impl.utils.CdsModelUtils;
import com.sap.cds.services.impl.utils.CdsServiceUtils;
import com.sap.cds.services.impl.utils.NameOnlyCdsEntity;
import com.sap.cds.services.messages.Messages;
import com.sap.cds.services.request.FeatureTogglesInfo;
import com.sap.cds.services.request.ParameterInfo;
import com.sap.cds.services.request.RequestContext;
import com.sap.cds.services.request.UserInfo;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ClassMethods;
import com.sap.cds.services.utils.ErrorStatusException;
import com.sap.cds.services.utils.ResultUtils;
import com.sap.cds.services.utils.StringUtils;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

public class EventContextImpl
implements EventContextSPI {
    private static final ClassMethods eventContextImplMethods = ClassMethods.create(EventContextImpl.class);
    private static final Map<Class<? extends EventContext>, Function<EventContext, ? extends EventContext>> implClasses = new HashMap<Class<? extends EventContext>, Function<EventContext, ? extends EventContext>>();
    private final Map<String, Object> map;
    private Service service;
    private final String event;
    private final String entityName;
    private CdsEntity target;
    private Runnable onChain;
    private boolean completed;

    public EventContextImpl(String event, String entityName) {
        implClasses.put(CdsCreateEventContext.class, CdsCreateEventContextImpl::new);
        implClasses.put(CdsDeleteEventContext.class, CdsDeleteEventContextImpl::new);
        implClasses.put(CdsReadEventContext.class, CdsReadEventContextImpl::new);
        implClasses.put(CdsUpdateEventContext.class, CdsUpdateEventContextImpl::new);
        implClasses.put(CdsUpsertEventContext.class, CdsUpsertEventContextImpl::new);
        implClasses.put(CalcWhereConditionEventContext.class, CalcWhereConditionEventContextImpl::new);
        implClasses.put(EntityAccessEventContext.class, EntityAccessEventContextImpl::new);
        implClasses.put(FunctionAccessEventContext.class, FunctionAccessEventContextImpl::new);
        implClasses.put(GetRestrictionEventContext.class, GetRestrictionEventContextImpl::new);
        implClasses.put(ServiceAccessEventContext.class, ServiceAccessEventContextImpl::new);
        implClasses.put(ConfigChangeLogContext.class, ConfigChangeLogContextImpl::new);
        implClasses.put(DataAccessLogContext.class, DataAccessLogContextImpl::new);
        implClasses.put(DataModificationLogContext.class, DataModificationLogContextImpl::new);
        implClasses.put(SecurityLogContext.class, SecurityLogContextImpl::new);
        implClasses.put(DraftReadEventContext.class, DraftReadEventContextImpl::new);
        implClasses.put(ActiveReadEventContext.class, ActiveReadEventContextImpl::new);
        implClasses.put(DraftCancelEventContext.class, DraftCancelEventContextImpl::new);
        implClasses.put(DraftCreateEventContext.class, DraftCreateEventContextImpl::new);
        implClasses.put(DraftEditEventContext.class, DraftEditEventContextImpl::new);
        implClasses.put(DraftGcEventContext.class, DraftGcEventContextImpl::new);
        implClasses.put(DraftNewEventContext.class, DraftNewEventContextImpl::new);
        implClasses.put(DraftPatchEventContext.class, DraftPatchEventContextImpl::new);
        implClasses.put(DraftPrepareEventContext.class, DraftPrepareEventContextImpl::new);
        implClasses.put(DraftSaveEventContext.class, DraftSaveEventContextImpl::new);
        this.map = new HashMap<String, Object>();
        this.completed = false;
        this.event = event;
        this.entityName = StringUtils.isEmpty((String)entityName) ? null : entityName;
    }

    public CdsModel getModel() {
        return this.getRequestContext().getModel();
    }

    public ServiceCatalog getServiceCatalog() {
        return this.getRequestContext().getServiceCatalog();
    }

    public ParameterInfo getParameterInfo() {
        return this.getRequestContext().getParameterInfo();
    }

    public UserInfo getUserInfo() {
        return this.getRequestContext().getUserInfo();
    }

    public AuthenticationInfo getAuthenticationInfo() {
        return this.getRequestContext().getAuthenticationInfo();
    }

    public FeatureTogglesInfo getFeatureTogglesInfo() {
        return this.getRequestContext().getFeatureTogglesInfo();
    }

    public Messages getMessages() {
        return this.getRequestContext().getMessages();
    }

    public CdsRuntime getCdsRuntime() {
        ServiceSPI serviceSPI = CdsServiceUtils.getServiceSPI(this.service);
        return serviceSPI != null ? serviceSPI.getCdsRuntime() : null;
    }

    private RequestContext getRequestContext() {
        return RequestContext.getCurrent((CdsRuntime)this.getCdsRuntime());
    }

    public ChangeSetContext getChangeSetContext() {
        return ChangeSetContext.getCurrent();
    }

    public Service getService() {
        return this.service;
    }

    @Override
    public void setService(Service service) {
        this.service = service;
    }

    public String getEvent() {
        return this.event;
    }

    public CdsEntity getTarget() {
        RequestContext context;
        if (this.entityName == null) {
            return null;
        }
        if (this.target == null && (context = RequestContextImpl.getCurrentOrNull(this.getCdsRuntime())) != null && context.getModel() != null) {
            this.target = CdsModelUtils.getEntityOrThrow(context.getModel(), this.entityName);
        }
        return this.target != null ? this.target : new NameOnlyCdsEntity(this.entityName);
    }

    public <T extends EventContext> T as(Class<T> clazz) {
        if (clazz.isAssignableFrom(this.getClass())) {
            return (T)this;
        }
        EventName expectedEventName = clazz.getAnnotation(EventName.class);
        if (expectedEventName == null || StringUtils.isEmpty((String)expectedEventName.value())) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.EVENT_CONTEXT_MISSING_ANNOTATION, new Object[]{clazz.getName()});
        }
        if (!expectedEventName.value().equals("*") && !this.event.equals(expectedEventName.value())) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.EVENT_CONTEXT_EVENT_MISMATCH, new Object[]{clazz.getName(), expectedEventName.value(), this.event});
        }
        if (implClasses.containsKey(clazz)) {
            return (T)implClasses.get(clazz).apply(this);
        }
        EventContext mapAccessor = (EventContext)Struct.access(this.map).as(clazz);
        return (T)((EventContext)Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz, EventContextSPI.class}, (proxy, method, methodArgs) -> {
            Type[] types;
            Method originalMethod = eventContextImplMethods.lookupMethod(method);
            if (originalMethod != null) {
                if (method.getName().equals("as") && methodArgs.length == 1 && ((Class)methodArgs[0]).isAssignableFrom(clazz)) {
                    return proxy;
                }
                return originalMethod.invoke((Object)this, methodArgs);
            }
            if (EventContextImpl.isResultSetter(method) && (types = method.getGenericParameterTypes()).length == 1 && types[0].getTypeName().equals("java.lang.Iterable<? extends java.util.Map<java.lang.String, ?>>")) {
                methodArgs[0] = ResultUtils.convert((Iterable)((Iterable)methodArgs[0]));
            }
            Object obj = method.invoke((Object)mapAccessor, methodArgs);
            if (EventContextImpl.isResultSetter(method)) {
                this.setCompleted();
            }
            return obj;
        }));
    }

    public Set<String> keySet() {
        return Collections.unmodifiableSet(this.map.keySet());
    }

    public Object get(String key) {
        return this.map.get(key);
    }

    public void put(String key, Object value) {
        this.map.put(key, value);
    }

    public void setCompleted() {
        this.completed = true;
    }

    public boolean isCompleted() {
        return this.completed;
    }

    public void proceed() {
        if (this.onChain == null) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.PROCEED_OUTSIDE_ON, new Object[0]);
        }
        this.onChain.run();
    }

    @Override
    public void setOnChain(Runnable onChain) {
        this.onChain = onChain;
    }

    private static boolean isResultSetter(Method method) {
        return method.getName().equals("setResult") || method.getName().equals("result") && method.getParameterCount() == 1;
    }
}

