/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.authorization;

import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.CqnStatement;
import com.sap.cds.services.EventContext;
import com.sap.cds.services.ServiceDelegator;
import com.sap.cds.services.authorization.ActionAccessEventContext;
import com.sap.cds.services.authorization.AuthorizationService;
import com.sap.cds.services.authorization.CalcWhereConditionEventContext;
import com.sap.cds.services.authorization.EntityAccessEventContext;
import com.sap.cds.services.authorization.FunctionAccessEventContext;
import com.sap.cds.services.authorization.ServiceAccessEventContext;

public class AuthorizationServiceImpl
extends ServiceDelegator
implements AuthorizationService {
    public AuthorizationServiceImpl(String name) {
        super(name);
    }

    public boolean hasServiceAccess(String serviceName, String event) {
        ServiceAccessEventContext context = ServiceAccessEventContext.create();
        context.setAccessServiceName(serviceName);
        context.setAccessEventName(event);
        this.emit((EventContext)context);
        Boolean result = context.getResult();
        return result != null ? result : false;
    }

    public boolean hasEntityAccess(String entityName, String event) {
        return this.hasEntityAccess(entityName, event, null);
    }

    public boolean hasEntityAccess(String entityName, String event, CqnStatement query) {
        EntityAccessEventContext context = EntityAccessEventContext.create((String)entityName);
        context.setAccessQuery(query);
        context.setAccessEntityName(entityName);
        context.setAccessEventName(event);
        this.emit((EventContext)context);
        Boolean result = context.getResult();
        return result != null ? result : false;
    }

    public boolean hasFunctionAccess(String entityName, String functionName) {
        FunctionAccessEventContext context = FunctionAccessEventContext.create();
        context.setFunctionName(functionName);
        context.setEntityName(entityName);
        this.emit((EventContext)context);
        Boolean result = context.getResult();
        return result != null ? result : false;
    }

    public boolean hasActionAccess(String entityName, String actionName) {
        ActionAccessEventContext context = ActionAccessEventContext.create();
        context.setActionName(actionName);
        context.setEntityName(entityName);
        this.emit((EventContext)context);
        Boolean result = context.getResult();
        return result != null ? result : false;
    }

    public CqnPredicate calcWhereCondition(String entityName, String event) {
        CalcWhereConditionEventContext context = CalcWhereConditionEventContext.create((String)entityName);
        context.setEntityName(entityName);
        context.setEventName(event);
        this.emit((EventContext)context);
        return context.getResult();
    }
}

