/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.authorization;

import com.sap.cds.ql.cqn.CqnReference;
import com.sap.cds.reflect.CdsAssociationType;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.reflect.CdsStructuredType;
import java.util.List;
import java.util.ListIterator;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Predicate;

class ReferenceAssociationTraverser {
    static final Predicate<CdsElement> NO_COMPOSITIONS = e -> !((CdsAssociationType)e.getType().as(CdsAssociationType.class)).isComposition();

    private ReferenceAssociationTraverser() {
    }

    static <T extends CqnReference.Segment> void traverseAsRelative(CdsStructuredType root, List<T> segments, Predicate<CdsElement> takeIf, BiFunction<CdsStructuredType, T, T> action) {
        StringBuilder path = new StringBuilder();
        ListIterator iterator = segments.listIterator();
        while (iterator.hasNext()) {
            root = ReferenceAssociationTraverser.traverseSegment(root, iterator, path, takeIf, (type, s) -> {
                CqnReference.Segment copy = (CqnReference.Segment)action.apply((CdsStructuredType)type, (Object)s);
                iterator.set(copy);
            });
        }
    }

    static <T extends CqnReference.Segment> void traverseAsRelative(CdsStructuredType root, List<T> segments, Predicate<CdsElement> takeIf, BiConsumer<CdsStructuredType, T> action) {
        StringBuilder path = new StringBuilder();
        ListIterator<T> iterator = segments.listIterator();
        while (iterator.hasNext()) {
            root = ReferenceAssociationTraverser.traverseSegment(root, iterator, path, takeIf, action);
        }
    }

    static <T extends CqnReference.Segment> void traverseAsAbsolute(CdsStructuredType root, List<T> segments, Predicate<CdsElement> takeIf, BiFunction<CdsStructuredType, T, T> action) {
        ListIterator iterator = segments.listIterator();
        if (iterator.hasNext()) {
            iterator.set((CqnReference.Segment)action.apply(root, (CdsStructuredType)((CqnReference.Segment)iterator.next())));
            StringBuilder path = new StringBuilder();
            while (iterator.hasNext()) {
                root = ReferenceAssociationTraverser.traverseSegment(root, iterator, path, takeIf, (type, s) -> {
                    CqnReference.Segment copy = (CqnReference.Segment)action.apply((CdsStructuredType)type, (CdsStructuredType)s);
                    iterator.set(copy);
                });
            }
        }
    }

    static <T extends CqnReference.Segment> void traverseAsAbsolute(CdsStructuredType root, List<T> segments, Predicate<CdsElement> takeIf, BiConsumer<CdsStructuredType, T> action) {
        ListIterator<T> iterator = segments.listIterator();
        if (iterator.hasNext()) {
            action.accept(root, (CdsStructuredType)((CqnReference.Segment)iterator.next()));
            StringBuilder path = new StringBuilder();
            while (iterator.hasNext()) {
                root = ReferenceAssociationTraverser.traverseSegment(root, iterator, path, takeIf, action);
            }
        }
    }

    private static <T extends CqnReference.Segment> CdsStructuredType traverseSegment(CdsStructuredType root, ListIterator<T> segmentIter, StringBuilder path, Predicate<CdsElement> takeIf, BiConsumer<CdsStructuredType, T> action) {
        CqnReference.Segment segment = (CqnReference.Segment)segmentIter.next();
        if ("$outer".equals(segment.id())) {
            return root;
        }
        if (!path.isEmpty()) {
            path.append(".").append(segment.id());
        } else {
            path.append(segment.id());
        }
        Optional element = root.findElement(path.toString());
        if (element.filter(e -> e.getType().isAssociation() && takeIf.test((CdsElement)e)).isPresent()) {
            root = ((CdsAssociationType)((CdsElement)element.get()).getType().as(CdsAssociationType.class)).getTarget();
            path.delete(0, path.length());
            action.accept(root, (CdsStructuredType)segment);
        }
        return root;
    }
}

