/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.cds;

import com.sap.cds.ql.CQL;
import com.sap.cds.ql.cqn.CqnDelete;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.CqnSelect;
import com.sap.cds.ql.cqn.CqnStatement;
import com.sap.cds.ql.cqn.CqnUpdate;
import com.sap.cds.ql.cqn.Modifier;
import com.sap.cds.reflect.CdsAnnotatable;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.services.EventContext;
import com.sap.cds.services.authorization.AuthorizationService;
import com.sap.cds.services.cds.ApplicationService;
import com.sap.cds.services.cds.CdsDeleteEventContext;
import com.sap.cds.services.cds.CdsReadEventContext;
import com.sap.cds.services.cds.CdsUpdateEventContext;
import com.sap.cds.services.draft.DraftEditEventContext;
import com.sap.cds.services.draft.DraftSaveEventContext;
import com.sap.cds.services.handler.EventHandler;
import com.sap.cds.services.handler.annotations.Before;
import com.sap.cds.services.handler.annotations.HandlerOrder;
import com.sap.cds.services.handler.annotations.ServiceName;
import com.sap.cds.services.impl.authorization.ReadStatementAuthorizationModifier;
import com.sap.cds.services.impl.utils.CdsModelUtils;
import com.sap.cds.services.utils.DraftUtils;
import com.sap.cds.services.utils.model.CqnUtils;
import com.sap.cds.util.CqnStatementUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ServiceName(value={"*"}, type={ApplicationService.class})
public class InstanceBasedAuthorizationHandler
implements EventHandler {
    private static final Logger logger = LoggerFactory.getLogger(InstanceBasedAuthorizationHandler.class);

    @Before(event={"*"})
    @HandlerOrder(value=-10700)
    private void checkAuthorization(EventContext context) {
        if (!context.getUserInfo().isPrivileged()) {
            this.extendStatements(context);
        }
    }

    private void extendStatements(EventContext context) {
        AuthorizationService authService = (AuthorizationService)context.getServiceCatalog().getService(AuthorizationService.class, "AuthorizationService$Default");
        String event = context.getEvent();
        String serviceName = ((ApplicationService)context.getService()).getDefinition().getQualifiedName();
        CdsEntity targetEntity = context.getTarget();
        String entityName = null;
        if (targetEntity != null) {
            entityName = targetEntity.getQualifiedName();
        }
        if (event.equals("READ")) {
            CdsReadEventContext cdsContext = (CdsReadEventContext)context.as(CdsReadEventContext.class);
            if (Boolean.TRUE.equals(context.getCdsRuntime().getEnvironment().getCdsProperties().getSecurity().getAuthorization().getDeep().isEnabled())) {
                CqnSelect secured = (CqnSelect)CQL.copy((CqnStatement)cdsContext.getCqn(), (Modifier)new ReadStatementAuthorizationModifier(authService, cdsContext));
                if (logger.isDebugEnabled()) {
                    logger.debug("Statement is extended with security conditions for target '{}' of service '{}': '{}'", new Object[]{entityName, serviceName, CqnStatementUtils.anonymizeStatement((CqnStatement)secured)});
                }
                cdsContext.setCqn(secured);
            } else {
                CqnSelect select = cdsContext.getCqn();
                CqnPredicate wherePred = authService.calcWhereCondition(entityName, "READ");
                if (wherePred != null) {
                    if (targetEntity != null && DraftUtils.isDraftEnabled((CdsAnnotatable)context.getTarget())) {
                        wherePred = CQL.or((CqnPredicate)wherePred, (CqnPredicate)CQL.get((String)"IsActiveEntity").eq((Object)false));
                    }
                    CqnUtils.addWhere((CqnStatement)select, (CqnPredicate)wherePred);
                }
                cdsContext.setCqn(select);
            }
        }
        if (event.equals("DELETE") || event.equals("UPDATE") || event.equals("draftEdit") || event.equals("draftActivate")) {
            CqnPredicate wherePred = authService.calcWhereCondition(entityName, event);
            if (wherePred != null) {
                if (context.getEvent().equals("DELETE")) {
                    CdsDeleteEventContext deleteContext = (CdsDeleteEventContext)context.as(CdsDeleteEventContext.class);
                    if (targetEntity != null && DraftUtils.isDraftEnabled((CdsAnnotatable)targetEntity)) {
                        wherePred = CQL.or((CqnPredicate)wherePred, (CqnPredicate)CQL.get((String)"IsActiveEntity").eq((Object)false));
                    }
                    cqn = (CqnDelete)CqnUtils.addWhere((CqnStatement)deleteContext.getCqn(), (CqnPredicate)wherePred);
                    deleteContext.setCqn(cqn);
                } else if (context.getEvent().equals("UPDATE")) {
                    CdsUpdateEventContext updateContext = (CdsUpdateEventContext)context.as(CdsUpdateEventContext.class);
                    if (targetEntity != null && DraftUtils.isDraftEnabled((CdsAnnotatable)targetEntity)) {
                        wherePred = CQL.or((CqnPredicate)wherePred, (CqnPredicate)CQL.get((String)"IsActiveEntity").eq((Object)false));
                    }
                    cqn = (CqnUpdate)CqnUtils.addWhere((CqnStatement)updateContext.getCqn(), (CqnPredicate)wherePred);
                    updateContext.setCqn((CqnUpdate)cqn);
                } else if (event.equals("draftEdit")) {
                    DraftEditEventContext draftEditContext = (DraftEditEventContext)context.as(DraftEditEventContext.class);
                    cqn = (CqnSelect)CqnUtils.addWhere((CqnStatement)draftEditContext.getCqn(), (CqnPredicate)wherePred);
                    draftEditContext.setCqn((CqnSelect)cqn);
                } else if (event.equals("draftActivate")) {
                    DraftSaveEventContext saveContext = (DraftSaveEventContext)context.as(DraftSaveEventContext.class);
                    cqn = (CqnSelect)CqnUtils.addWhere((CqnStatement)saveContext.getCqn(), (CqnPredicate)wherePred);
                    saveContext.setCqn((CqnSelect)cqn);
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("Created CQN authorization predicate {} for entity '{}' of service '{}', event {} and user {}", new Object[]{wherePred.toJson(), entityName, serviceName, event, context.getUserInfo().getName()});
                }
            } else if (logger.isDebugEnabled()) {
                logger.debug("No CQN authorization predicate required for entity '{}' of service '{}', event {} and user {}", new Object[]{entityName, serviceName, event, context.getUserInfo().getName()});
            }
        } else {
            boolean regardCustomEvents = context.getCdsRuntime().getEnvironment().getCdsProperties().getSecurity().getAuthorization().getInstanceBased().getCustomEvents().isEnabled();
            if (regardCustomEvents && !CdsModelUtils.isStandardCdsEvent(event) && entityName != null) {
                CqnPredicate wherePred = authService.calcWhereCondition(entityName, event);
                if (wherePred != null && targetEntity != null && DraftUtils.isDraftEnabled((CdsAnnotatable)targetEntity)) {
                    wherePred = CQL.or((CqnPredicate)wherePred, (CqnPredicate)CQL.get((String)"IsActiveEntity").eq((Object)false));
                }
                if ((cqn = (CqnStatement)context.get("cqn")) != null && (cqn.isSelect() || cqn.isUpdate() || cqn.isDelete())) {
                    context.put("cqn", (Object)CqnUtils.addWhere((CqnStatement)cqn, (CqnPredicate)wherePred));
                }
                if (logger.isDebugEnabled() && wherePred != null) {
                    logger.debug("Created CQN authorization predicate {} for entity '{}' of service '{}', event {} and user {}", new Object[]{wherePred.toJson(), entityName, serviceName, event, context.getUserInfo().getName()});
                }
            }
        }
        logger.debug("Instance-based authorization check passed for event '{}' on service '{}'", (Object)event, (Object)serviceName);
    }
}

