/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.outbox.persistence;

import com.sap.cds.services.impl.outbox.persistence.OutboxStatistics;
import com.sap.cds.services.impl.outbox.persistence.PersistentOutbox;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.runtime.CdsRuntimeAware;
import com.sap.cds.services.utils.info.CdsInfo;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;

public class CdsOutboxInfo
implements CdsInfo,
CdsRuntimeAware {
    private CdsRuntime runtime;

    public void setCdsRuntime(CdsRuntime runtime) {
        this.runtime = runtime;
    }

    public String name() {
        return "outboxes";
    }

    public Object info(CdsInfo.Details details) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        List<PersistentOutbox> outboxServices = this.runtime.getServiceCatalog().getServices(PersistentOutbox.class).toList();
        if (!outboxServices.isEmpty()) {
            this.addOutboxNames(result, outboxServices);
            if (details.ordinal() >= CdsInfo.Details.MEDIUM.ordinal()) {
                this.addOutboxTelemetryData(result, outboxServices);
            }
        } else {
            result.put("message", "No persistent outbox services configured.");
        }
        return result;
    }

    private void addOutboxTelemetryData(Map<String, Object> result, List<PersistentOutbox> outboxServices) {
        outboxServices.forEach(outbox -> {
            Map outboxInfo = (Map)result.get(outbox.getName());
            Map outboxStatistics = (Map)outboxInfo.computeIfAbsent("statistics", k -> new HashMap());
            Collection<OutboxStatistics> statistics = outbox.getStatistics();
            AtomicLong statisticsCount = new AtomicLong();
            statistics.forEach(stats -> {
                statisticsCount.incrementAndGet();
                outboxStatistics.compute("incomingMessagesOfInstance", (k, v) -> v == null ? stats.getIncomingMessages() : v + stats.getIncomingMessages());
                outboxStatistics.compute("outgoingMessagesOfInstance", (k, v) -> v == null ? stats.getOutgoingMessages() : v + stats.getOutgoingMessages());
                outboxStatistics.compute("coldEntries", (k, v) -> v == null ? stats.getColdEntries() : v + stats.getColdEntries());
                outboxStatistics.compute("remainingEntries", (k, v) -> v == null ? stats.getRemainingEntries() : v + stats.getRemainingEntries());
                outboxStatistics.compute("maxStorageTime", (k, v) -> v == null ? stats.getMaxStorageTime() : Long.max(v, stats.getMaxStorageTime()));
                outboxStatistics.compute("avgStorageTime", (k, v) -> v == null ? stats.getMedianStorageTime() : v + stats.getMedianStorageTime());
                outboxStatistics.compute("minStorageTime", (k, v) -> v == null ? stats.getMinStorageTime() : Long.min(v, stats.getMinStorageTime()));
            });
            if (statisticsCount.get() > 1L) {
                outboxStatistics.compute("avgStorageTime", (k, v) -> v == null ? 0L : v / statisticsCount.get());
            }
        });
    }

    private void addOutboxNames(Map<String, Object> result, List<PersistentOutbox> outboxServices) {
        outboxServices.forEach(outbox -> result.put(outbox.getName(), new HashMap()));
    }
}

