/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.application;

import com.sap.cds.services.ErrorStatuses;
import com.sap.cds.services.EventContext;
import com.sap.cds.services.application.ApplicationLifecycleService;
import com.sap.cds.services.application.ErrorResponseEventContext;
import com.sap.cds.services.auditlog.AuditLogService;
import com.sap.cds.services.auditlog.event.UnauthorizedRequestEventContext;
import com.sap.cds.services.environment.CdsProperties;
import com.sap.cds.services.handler.EventHandler;
import com.sap.cds.services.handler.annotations.After;
import com.sap.cds.services.handler.annotations.ServiceName;

@ServiceName(value={"*"}, type={ApplicationLifecycleService.class})
public class SecurityAuditEventHandler
implements EventHandler {
    private AuditLogService auditLogService;

    public SecurityAuditEventHandler(AuditLogService auditLogService) {
        this.auditLogService = auditLogService;
    }

    @After
    public void logSecurityError(ErrorResponseEventContext context) {
        boolean isForbiddenEnabled = SecurityAuditEventHandler.getStandardEvents((EventContext)context).getUnauthorizedRequestEvent().isEnabled();
        if (isForbiddenEnabled) {
            int httpStatus = context.getException().getErrorStatus().getHttpStatus();
            if (isForbiddenEnabled && httpStatus == ErrorStatuses.FORBIDDEN.getHttpStatus()) {
                UnauthorizedRequestEventContext ctx = UnauthorizedRequestEventContext.create();
                ctx.put("rejectReason", (Object)context.getException().getMessage());
                this.auditLogService.emit((EventContext)ctx);
            }
        }
    }

    private static CdsProperties.AuditLog.StandardEvents getStandardEvents(EventContext ctx) {
        return ctx.getCdsRuntime().getEnvironment().getCdsProperties().getAuditLog().getStandardEvents();
    }
}

