/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.auditlog;

import com.sap.cds.CdsData;
import com.sap.cds.CdsDiffProcessor;
import com.sap.cds.impl.DataProcessor;
import com.sap.cds.impl.diff.DiffProcessor;
import com.sap.cds.ql.cqn.Path;
import com.sap.cds.reflect.CdsAssociationType;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.services.auditlog.Action;
import com.sap.cds.services.auditlog.ChangedAttribute;
import com.sap.cds.services.auditlog.DataModification;
import com.sap.cds.services.impl.auditlog.PersonalDataAnalyzer;
import com.sap.cds.services.impl.auditlog.PersonalDataCaches;
import com.sap.cds.services.impl.auditlog.PersonalDataMeta;
import com.sap.cds.services.runtime.CdsRuntime;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.stream.StreamSupport;

class PersonalDataAnalyzerModification
extends PersonalDataAnalyzer {
    private List<? extends Map<String, Object>> oldData;

    PersonalDataAnalyzerModification(CdsStructuredType entity, PersonalDataCaches caches, CdsRuntime runtime) {
        super(entity, caches, runtime);
    }

    PersonalDataAnalyzerModification(CdsEntity entity, List<? extends Map<String, Object>> data, PersonalDataCaches caches, CdsRuntime runtime) {
        this((CdsStructuredType)entity, caches, runtime);
        this.setData(data);
    }

    public void setOldData(List<? extends CdsData> oldData) {
        this.oldData = oldData;
    }

    public List<DataModification> getDataModifications() {
        if (Boolean.TRUE.equals(this.personalData.getLogInsert().isEnabled()) || Boolean.TRUE.equals(this.personalData.getLogUpdate().isEnabled()) || Boolean.TRUE.equals(this.personalData.getLogDelete().isEnabled())) {
            DataToModifications visitor = new DataToModifications(this.caches);
            DiffProcessor.create().forDeepTraversal().add((path, element, type) -> {
                PersonalDataMeta meta = visitor.metadataProvider.getMeta(PersonalDataAnalyzerModification.getTarget(element, path));
                if (element != null && !element.getType().isAssociation()) {
                    return meta.getPersonalDataNames().contains(element.getName());
                }
                return meta.hasPersonalData();
            }, (CdsDiffProcessor.DiffVisitor)visitor).process(this.data, this.oldData, this.entity);
            return visitor.getResult();
        }
        return Collections.emptyList();
    }

    @Override
    public boolean hasPersonalData() {
        if (this.data != null) {
            return this.hasPersonalData(this.entity, this.data);
        }
        return this.getMeta(this.entity).hasPersonalData();
    }

    private boolean hasPersonalData(CdsStructuredType entity, Iterable<? extends Map<String, Object>> data) {
        final AtomicBoolean hasPersonalData = new AtomicBoolean(false);
        DataProcessor.create().action(new DataProcessor.Action(){

            public void entries(Path path, CdsElement element, CdsStructuredType type, Iterable<Map<String, Object>> dataList) {
                PersonalDataMeta meta = PersonalDataAnalyzerModification.this.getMeta(type);
                if (meta != null) {
                    Set<String> personal = meta.getPersonalDataNames();
                    if (!hasPersonalData.get() && meta.hasPersonalData() && StreamSupport.stream(dataList.spliterator(), false).anyMatch(dataRow -> dataRow.keySet().stream().anyMatch(personal::contains))) {
                        hasPersonalData.set(true);
                    }
                }
            }
        }).process(data, entity);
        return hasPersonalData.get();
    }

    private static CdsStructuredType getTarget(CdsElement element, Path path) {
        if (element != null && element.getType().isAssociation()) {
            return ((CdsAssociationType)element.getType().as(CdsAssociationType.class)).getTarget();
        }
        return path.target().type();
    }

    private class DataToModifications
    implements CdsDiffProcessor.DiffVisitor {
        private final PersonalDataCaches metadataProvider;
        private final Map<Path, DataModification> elementChanges = new HashMap<Path, DataModification>();
        private final List<DataModification> structureChanges = new LinkedList<DataModification>();

        DataToModifications(PersonalDataCaches metadataProvider) {
            this.metadataProvider = metadataProvider;
        }

        public void changed(Path newPath, Path ignored, CdsElement element, Object newValue, Object oldValue) {
            if (Boolean.TRUE.equals(PersonalDataAnalyzerModification.this.personalData.getLogUpdate().isEnabled())) {
                DataModification modification = this.elementChanges.computeIfAbsent(newPath, p -> this.newModification(Action.UPDATE, p.target().values(), this.metadataProvider.getMeta(p.target().type())));
                ChangedAttribute attribute = ChangedAttribute.create();
                attribute.setName(element.getName());
                if (newValue != null) {
                    attribute.setNewValue(newValue.toString());
                }
                if (oldValue != null) {
                    attribute.setOldValue(oldValue.toString());
                }
                modification.getAttributes().add(attribute);
            }
        }

        public void added(Path newPath, Path ignored, CdsElement association, Map<String, Object> newValue) {
            if (Boolean.TRUE.equals(PersonalDataAnalyzerModification.this.personalData.getLogInsert().isEnabled())) {
                PersonalDataMeta meta = this.metadataProvider.getMeta(PersonalDataAnalyzerModification.getTarget(association, newPath));
                DataModification modification = this.newModification(Action.CREATE, newValue, meta);
                this.withAttributes(modification, newValue, meta, ChangedAttribute::setNewValue);
                this.structureChanges.add(modification);
            }
        }

        public void removed(Path newPath, Path ignored, CdsElement association, Map<String, Object> oldValue) {
            if (Boolean.TRUE.equals(PersonalDataAnalyzerModification.this.personalData.getLogDelete().isEnabled())) {
                PersonalDataMeta meta = this.metadataProvider.getMeta(PersonalDataAnalyzerModification.getTarget(association, newPath));
                DataModification modification = this.newModification(Action.DELETE, oldValue, meta);
                this.withAttributes(modification, oldValue, meta, ChangedAttribute::setOldValue);
                this.structureChanges.add(modification);
            }
        }

        public List<DataModification> getResult() {
            LinkedList<DataModification> result = new LinkedList<DataModification>(this.elementChanges.values());
            result.addAll(this.structureChanges);
            return result;
        }

        private void withAttributes(DataModification modification, Map<String, Object> data, PersonalDataMeta meta, BiConsumer<ChangedAttribute, String> action) {
            modification.setAttributes(meta.getPersonalDataNames().stream().filter(e -> data.get(e) != null).map(e -> {
                ChangedAttribute attribute = ChangedAttribute.create();
                attribute.setName(e);
                action.accept(attribute, data.get(e).toString());
                return attribute;
            }).toList());
        }

        private DataModification newModification(Action action, Map<String, Object> data, PersonalDataMeta meta) {
            DataModification modification = DataModification.create();
            modification.setAction(action);
            modification.setDataObject(PersonalDataAnalyzerModification.this.createDataObject(data, meta));
            modification.setDataSubject(PersonalDataAnalyzerModification.this.createDataSubject(data, meta));
            modification.setAttributes(new LinkedList());
            return modification;
        }
    }
}

