/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.auditlog.events;

import com.sap.cds.CdsData;
import com.sap.cds.Struct;
import com.sap.cds.ql.CdsName;
import com.sap.cds.services.environment.ApplicationInfo;
import com.sap.cds.services.request.ParameterInfo;
import com.sap.cds.services.request.RequestContext;
import com.sap.cds.services.runtime.CdsRuntime;

@CdsName(value="com.sap.auditlog.events.AuditEvent")
public interface AuditEvent
extends CdsData {
    public static final String EVENT = "event";
    public static final String DATA = "data";

    public Event getEvent();

    public void setEvent(Event var1);

    public static AuditEvent create() {
        return (AuditEvent)Struct.create(AuditEvent.class);
    }

    public static AuditEvent create(CdsRuntime runtime) {
        RequestContext context = RequestContext.getCurrent((CdsRuntime)runtime);
        AuditEvent auditlogEvent = (AuditEvent)Struct.create(AuditEvent.class);
        Event event = Event.create();
        auditlogEvent.setEvent(event);
        Event.Metadata meta = Event.Metadata.create();
        ParameterInfo pInfo = context.getParameterInfo();
        String ip = pInfo.getHeader("x-forwarded-for");
        ip = null == ip ? pInfo.getHeader("x-real-ip") : ip;
        meta.setSourceIp(ip);
        meta.setCorrelationId(pInfo.getCorrelationId());
        meta.setPrincipalId(context.getUserInfo().getName());
        meta.setTenantId(context.getUserInfo().getTenant());
        Event.Metadata.AppContext appContext = Event.Metadata.AppContext.create();
        ApplicationInfo appInfo = runtime.getEnvironment().getApplicationInfo();
        if (!appInfo.getClass().getName().equals("com.sap.cds.feature.k8s.K8sApplicationInfoProvider.K8sApplicationInfo")) {
            appContext.setName(appInfo.getName());
            meta.setAppContext(appContext);
            meta.setAppId(appInfo.getId());
        }
        event.setMetadata(meta);
        return auditlogEvent;
    }

    public static interface Event
    extends CdsData {
        public static final String METADATA = "metadata";

        public Metadata getMetadata();

        public void setMetadata(Metadata var1);

        public static Event create() {
            return (Event)Struct.create(Event.class);
        }

        public static interface Metadata
        extends CdsData {
            public static final String SOURCE_IP = "sourceIp";
            public static final String PRINCIPAL_ID = "principalId";
            public static final String APP_ID = "appId";
            public static final String APP_CONTEXT = "appContext";

            public String getSourceIp();

            public void setSourceIp(String var1);

            public String getPrincipalId();

            public void setPrincipalId(String var1);

            public String getAppId();

            public void setAppId(String var1);

            public String getTenantId();

            public void setTenantId(String var1);

            public String getCorrelationId();

            public void setCorrelationId(String var1);

            public AppContext getAppContext();

            public void setAppContext(AppContext var1);

            public static Metadata create() {
                return (Metadata)Struct.create(Metadata.class);
            }

            public static interface AppContext
            extends CdsData {
                public static final String NAME = "name";

                public String getName();

                public void setName(String var1);

                public static AppContext create() {
                    return (AppContext)Struct.create(AppContext.class);
                }
            }
        }
    }
}

