/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.authorization;

import com.sap.cds.impl.builder.model.ExpandBuilder;
import com.sap.cds.impl.builder.model.StructuredTypeRefImpl;
import com.sap.cds.ql.CQL;
import com.sap.cds.ql.Expand;
import com.sap.cds.ql.Predicate;
import com.sap.cds.ql.Select;
import com.sap.cds.ql.cqn.CqnElementRef;
import com.sap.cds.ql.cqn.CqnExpand;
import com.sap.cds.ql.cqn.CqnInline;
import com.sap.cds.ql.cqn.CqnMatchPredicate;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.CqnReference;
import com.sap.cds.ql.cqn.CqnSelect;
import com.sap.cds.ql.cqn.CqnSelectListItem;
import com.sap.cds.ql.cqn.CqnStatement;
import com.sap.cds.ql.cqn.CqnStructuredTypeRef;
import com.sap.cds.ql.cqn.CqnValue;
import com.sap.cds.ql.cqn.Modifier;
import com.sap.cds.ql.impl.ExpressionVisitor;
import com.sap.cds.reflect.CdsAnnotatable;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.services.authorization.AuthorizationService;
import com.sap.cds.services.cds.CdsReadEventContext;
import com.sap.cds.services.impl.authorization.ReferenceAssociationTraverser;
import com.sap.cds.services.utils.DraftUtils;
import com.sap.cds.util.CdsModelUtils;
import com.sap.cds.util.CqnStatementUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class ReadStatementAuthorizationModifier
implements Modifier {
    private static final Predicate IS_ACTIVE_EQ_FALSE = CQL.get((String)"IsActiveEntity").eq((Object)false);
    private final AuthorizationService authorizationService;
    private final CdsModel model;
    private final String event;
    private final CdsStructuredType parentTarget;
    private final CdsStructuredType target;

    public ReadStatementAuthorizationModifier(AuthorizationService authService, CdsReadEventContext context) {
        this(authService, context.getModel(), context.getEvent(), null, (CdsStructuredType)CqnStatementUtils.targetEntity((CqnStatement)context.getCqn(), (CdsModel)context.getModel()));
    }

    private ReadStatementAuthorizationModifier(AuthorizationService authorizationService, CdsModel model, String event, CdsStructuredType parentTarget, CdsStructuredType target) {
        this.authorizationService = Objects.requireNonNull(authorizationService);
        this.model = Objects.requireNonNull(model);
        this.event = event;
        this.target = target;
        this.parentTarget = parentTarget;
    }

    public CqnStructuredTypeRef ref(CqnStructuredTypeRef ref) {
        CqnReference.Segment targetSegment = ref.targetSegment();
        ArrayList segments = new ArrayList(ref.segments());
        CdsEntity root = this.model.getEntity(ref.firstSegment());
        ReferenceAssociationTraverser.traverseAsAbsolute((CdsStructuredType)root, segments, ReferenceAssociationTraverser.NO_COMPOSITIONS, (type, segment) -> {
            if (segment != targetSegment) {
                return this.secureSegment((CdsStructuredType)type, (CqnReference.Segment)segment);
            }
            return segment;
        });
        return StructuredTypeRefImpl.typeRef(segments);
    }

    public CqnPredicate where(Predicate where) {
        CqnPredicate authorizationCondition = this.authorizationService.calcWhereCondition(this.target.getQualifiedName(), this.event);
        if (authorizationCondition != null) {
            return CQL.and((CqnPredicate)where, (CqnPredicate)this.authorizedOrInactive(this.target, authorizationCondition));
        }
        return where;
    }

    public CqnPredicate exists(Select<?> subQuery) {
        return CQL.exists((CqnSelect)((CqnSelect)CQL.copy(subQuery, (Modifier)this.newModifier((CdsStructuredType)CqnStatementUtils.targetEntity(subQuery, (CdsModel)this.model)))));
    }

    public CqnPredicate match(CqnMatchPredicate match) {
        List<CqnReference.Segment> segments = this.copyRef((CqnReference)match.ref());
        return CQL.match((CqnStructuredTypeRef)CQL.to(segments).as((String)match.ref().alias().orElse(null)).asRef(), (CqnPredicate)match.predicate().orElse(null), (CqnMatchPredicate.Quantifier)match.quantifier());
    }

    public CqnSelectListItem expand(CqnExpand expand) {
        ReadStatementAuthorizationModifier.rejectStarAndEmptyRefs((CqnReference)expand.ref());
        List<CqnReference.Segment> segments = this.copyRef((CqnReference)expand.ref());
        CdsStructuredType expandTarget = CdsModelUtils.target((CdsStructuredType)this.target, (List)expand.ref().segments());
        Expand result = CQL.to(segments).as((String)expand.ref().alias().orElse(null)).expand((Iterable)ExpressionVisitor.copy((Collection)expand.items(), (Modifier)this.newModifier(expandTarget))).limit(expand.top(), expand.skip()).inlineCount(expand.hasInlineCount()).orderBy(expand.orderBy()).as(expand.displayName());
        if (((ExpandBuilder)expand).lazy()) {
            ((ExpandBuilder)result).lazy(true);
        }
        return result;
    }

    public CqnSelectListItem inline(CqnInline inline) {
        ReadStatementAuthorizationModifier.rejectStarAndEmptyRefs((CqnReference)inline.ref());
        List<CqnReference.Segment> segments = this.copyRef((CqnReference)inline.ref());
        CdsStructuredType inlineTarget = CdsModelUtils.target((CdsStructuredType)this.target, (List)inline.ref().segments());
        return CQL.to(segments).as((String)inline.ref().alias().orElse(null)).inline((Iterable)ExpressionVisitor.copy((Collection)inline.items(), (Modifier)this.newModifier(inlineTarget)));
    }

    public CqnValue ref(CqnElementRef ref) {
        if (ref.size() < 2 || "$user".equals(ref.firstSegment())) {
            return ref;
        }
        ArrayList<CqnReference.Segment> segments = new ArrayList<CqnReference.Segment>(ref.segments());
        if ("$outer".equals(ref.firstSegment())) {
            this.secureRelativeRef(this.parentTarget, segments);
        } else {
            this.secureRelativeRef(this.target, segments);
        }
        return CQL.get(segments).as((String)ref.alias().orElse(null));
    }

    private List<CqnReference.Segment> copyRef(CqnReference ref) {
        ReadStatementAuthorizationModifier.rejectStarAndEmptyRefs(ref);
        ArrayList<CqnReference.Segment> segments = new ArrayList<CqnReference.Segment>(ref.segments());
        this.secureRelativeRef(this.target, segments);
        return segments;
    }

    private void secureRelativeRef(CdsStructuredType from, List<CqnReference.Segment> segments) {
        ReferenceAssociationTraverser.traverseAsRelative(from, segments, ReferenceAssociationTraverser.NO_COMPOSITIONS, this::secureSegment);
    }

    private CqnReference.Segment secureSegment(CdsStructuredType target, CqnReference.Segment segment) {
        CqnPredicate authorizationCondition = this.authorizedOrInactive(target, this.authorizationService.calcWhereCondition(target.getQualifiedName(), this.event));
        if (authorizationCondition != null) {
            return CQL.refSegment((String)segment.id(), (CqnPredicate)CQL.and((CqnPredicate)segment.filter().orElse(null), (CqnPredicate)authorizationCondition));
        }
        return segment;
    }

    private CqnPredicate authorizedOrInactive(CdsStructuredType target, CqnPredicate authorizationCondition) {
        if (DraftUtils.isDraftEnabled((CdsAnnotatable)target)) {
            return CQL.or((CqnPredicate)authorizationCondition, (CqnPredicate)IS_ACTIVE_EQ_FALSE);
        }
        return authorizationCondition;
    }

    private ReadStatementAuthorizationModifier newModifier(CdsStructuredType newTarget) {
        return new ReadStatementAuthorizationModifier(this.authorizationService, this.model, this.event, this.target, newTarget);
    }

    private static void rejectStarAndEmptyRefs(CqnReference ref) {
        if (ref.segments().isEmpty() || ref.firstSegment().equals("*")) {
            throw new IllegalStateException("The star expand or empty ref are not supposed to reach authorization check");
        }
    }
}

