/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
/**
 *
 */
package com.sap.cds.services.impl.draft;

import java.util.Map;

import com.sap.cds.Result;
import com.sap.cds.ql.cqn.CqnInsert;
import com.sap.cds.services.EventContext;
import com.sap.cds.services.draft.DraftCreateEventContext;
import com.sap.cds.services.draft.DraftService;
import com.sap.cds.services.impl.EventContextDelegator;
import com.sap.cds.services.utils.ResultUtils;

/**
 * Implementation of the {@link EventContext} for the {@link DraftService#EVENT_DRAFT_CREATE} event.
 */
public class DraftCreateEventContextImpl extends EventContextDelegator implements DraftCreateEventContext {

	public DraftCreateEventContextImpl(EventContext eventContext) {
		super(eventContext);
	}

	@Override
	public DraftService getService() {
		return (DraftService) super.getService();
	}

	private static final String PARAM_CQN = "cqn";
	private static final String PARAM_HAS_ACTIVE_ENTITY = "hasActiveEntity";
	private static final String PARAM_RESULT = "result";

	// IN
	/**
	 * @return the {@link CqnInsert} statement
	 */
	public CqnInsert getCqn() {
		return (CqnInsert)get(PARAM_CQN);
	}

	/**
	 * Sets the {@link CqnInsert} statement
	 * @param cqn the {@link CqnInsert} statement
	 */
	public void setCqn(CqnInsert cqn) {
		put(PARAM_CQN, cqn);
	}

	/**
	 * @return {@code true} if the draft is created from an existing active entity (edit scenario), {@code false} otherwise (new scenario)
	 */
	public Boolean getHasActiveEntity() {
		return (Boolean)get(PARAM_HAS_ACTIVE_ENTITY);
	}

	/**
	 * Set to {@code true} if the draft is created from an existing active entity (edit scenario), {@code false} otherwise (new scenario)
	 * @param hasActiveEntity {@code true} if the draft is created from an existing active entity (edit scenario), {@code false} otherwise (new scenario)
	 */
	public void setHasActiveEntity(boolean hasActiveEntity) {
		put(PARAM_HAS_ACTIVE_ENTITY, hasActiveEntity);
	}

	// OUT
	/**
	 * @return the {@link Result} of the {@link DraftService#EVENT_DRAFT_CREATE} event
	 */
	public Result getResult() {
		return (Result)get(PARAM_RESULT);
	}

	/**
	 * Sets the result of the {@link DraftService#EVENT_DRAFT_CREATE} event
	 * @param result a {@link Result} or a list of Maps, which will be transformed into a {@link Result}
	 */
	public void setResult(Iterable<? extends Map<String, ?>> result) {
		put(PARAM_RESULT, ResultUtils.convert(result));
		setCompleted();
	}

}
