/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.services.impl.messages;

import java.util.Objects;
import java.util.function.Function;

import com.sap.cds.ql.StructuredType;
import com.sap.cds.ql.cqn.Path;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.services.messages.Message;
import com.sap.cds.services.messages.MessageTarget;

public class MessageImpl implements Message {

	private final Severity severity;

	private final String message;

	private String code;

	private String longTextUrl;

	private MessageTarget target;

	public MessageImpl(Severity severity, String message) {
		this.message = Objects.requireNonNull(message, "message must not be null");
		this.severity = Objects.requireNonNull(severity, "severity must not be null");
	}

	@Override
	public String getCode() {
		return code;
	}

	@Override
	public String getMessage() {
		return message;
	}

	@Override
	public Severity getSeverity() {
		return severity;
	}

	@Override
	public MessageTarget getTarget() {
		return target;
	}

	@Override
	public String getLongTextUrl() {
		return longTextUrl;
	}

	@Override
	public Message longTextUrl(String longTextUrl) {
		this.longTextUrl = longTextUrl;
		return this;
	}

	@Override
	public Message code(String code) {
		this.code = code;
		return this;
	}

	@Override
	public Message target(String target) {
		this.target = MessageTargetImpl.create(target);
		return this;
	}

	@Override
	public Message target(Function<StructuredType<?>, Object> path) {
		return target(MessageTarget.PARAMETER_CQN, path);
	}

	@Override
	public Message target(String parameter, Function<StructuredType<?>, Object> path) {
		this.target = MessageTargetImpl.create(parameter, path);
		return this;
	}

	@Override
	public <E extends StructuredType<E>> Message target(Class<E> type, Function<E, Object> path) {
		return target(MessageTarget.PARAMETER_CQN, type, path);
	}

	@Override
	public <E extends StructuredType<E>> Message target(String parameter, Class<E> type, Function<E, Object> path) {
		this.target = MessageTargetImpl.create(parameter, type, path);
		return this;
	}

	@Override
	public Message target(Path path, CdsElement element) {
		this.target = MessageTargetImpl.create(path, element);
		return this;
	}

	public Message target(MessageTarget target) {
		this.target = target;
		return this;
	}
}
